% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{usa_mids}
\alias{usa_mids}
\title{United States Militarized Interstate Disputes (MIDs)}
\format{
A data frame with 14586 observations on the following 6 variables.
\describe{
\item{\code{dyad}}{a unique identifier for the dyad}
\item{\code{ccode1}}{the Correlates of War state code for the United States (2)}
\item{\code{ccode2}}{the Correlates of War state code for the other state in the dyad}
\item{\code{year}}{an observation year for the dyad}
\item{\code{midongoing}}{was there an ongoing inter-state dispute in the dyad-year?}
\item{\code{midonset}}{was there a new inter-state dispute onset in the dyad-year}
}
}
\usage{
usa_mids
}
\description{
This is a non-directed dyad-year data set for militarized interstate disputes involving
the United States. I created these to illustrate the \code{sbtscs()} function.
}
\details{
Data were generated some time ago. Rare cases where there were multiple disputes ongoing
in a given dyad-year were first whittled by isolating 1) unique dispute onsets. Thereafter,
the data select the 2) highest fatality, then 3) the highest hostility level, and then 4)
the longer dispute, until 5) just picking whichever one came first. There are no duplicate non-directed dyad-year observations.
}
\references{
Gibler, Douglas M., Steven V. Miller, and Erin K. Little. 2016. “An Analysis of the Militarized
Interstate Dispute (MID) Dataset, 1816-2001.” International Studies Quarterly 60(4): 719-730.
}
\keyword{datasets}
