% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsqca_methods.R
\name{print.tsqca_result}
\alias{print.tsqca_result}
\alias{print.otSweep_result}
\alias{print.dtSweep_result}
\alias{print.ctSweepS_result}
\alias{print.ctSweepM_result}
\title{Print method for TSQCA results}
\usage{
\method{print}{tsqca_result}(x, ...)

\method{print}{otSweep_result}(x, ...)

\method{print}{dtSweep_result}(x, ...)

\method{print}{ctSweepS_result}(x, ...)

\method{print}{ctSweepM_result}(x, ...)
}
\arguments{
\item{x}{A TSQCA result object returned by one of the sweep functions.}

\item{...}{Additional arguments (ignored).}
}
\value{
Invisibly returns \code{x}.
}
\description{
Displays a concise overview of TSQCA analysis results.
}
\examples{
\donttest{
data(sample_data)
result <- otSweep(
  dat = sample_data,
  outcome = "Y",
  conditions = c("X1", "X2", "X3"),
  sweep_range = 6:8,
  thrX = c(X1 = 7, X2 = 7, X3 = 7)
)
print(result)
}

}
