% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ttm_core.R
\name{ttm_est}
\alias{ttm_est}
\title{Fit the Topic Testlet Model (TTM)}
\usage{
ttm_est(scores, delta, max_iter = 100, tol = 1e-04)
}
\arguments{
\item{scores}{An N x J numeric matrix of item scores (0, 1, ...).}

\item{delta}{An N x K numeric matrix of topic proportions (from ttm_lda).}

\item{max_iter}{Maximum number of EM iterations.}

\item{tol}{Convergence tolerance.}
}
\value{
A list containing:
\item{theta}{Vector of estimated student abilities.}
\item{lambda}{Matrix of estimated topic penalties.}
\item{gamma}{Vector of person-specific testlet effects.}
\item{item_params}{List of step difficulties for each item.}
\item{AIC}{Akaike Information Criterion.}
\item{BIC}{Bayesian Information Criterion.}
}
\description{
Calibrates the TTM using score data and pre-computed topic proportions.
Uses a Variational Expectation-Maximization (VEM) approach to estimate
student ability (theta), topic penalties (lambda), and item parameters (b).
}
