% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitLinear.R
\name{fitLinear}
\alias{fitLinear}
\title{Fit linear regression model}
\usage{
fitLinear(formula, placebo, data, alternative, ...)
}
\arguments{
\item{formula}{an object of class \code{formula}. Must include \code{arm} and
endpoint in \code{data}. Covariates can be adjusted.}

\item{placebo}{Character. String indicating the placebo arm in \code{data$arm}.}

\item{data}{Data frame. Usually it is a locked data set.}

\item{alternative}{a character string specifying the alternative hypothesis,
must be one of \code{"greater"} or \code{"less"},
i.e., one-sided test is enforced. No default value.
\code{"greater"} means superiority of treatment over placebo is established
by a greater mean in treated arm.}

\item{...}{Subset conditions compatible with \code{dplyr::filter}.
\code{glm} will be fitted on this subset only. This argument can be useful
to create a subset of data for analysis when a trial consists of more
than two arms. By default, it is not specified,
all data will be used to fit the model. More than one condition can be
specified in \code{...}, e.g.,
\code{fitLinear(cfb ~ arm, 'pbo', data, 'greater', arm \%in\% c('pbo', 'low dose'), cfb > 0.5)},
which is equivalent to:
\code{fitLinear(cfb ~ arm, 'pbo', data, 'greater', arm \%in\% c('pbo', 'low dose') & cfb > 0.5)}.
Note that if more than one treatment arm are present in the data after
applying filter in \code{...}, models are fitted and tested for placebo verse
each of the treatment arms.}
}
\value{
a data frame with columns:
\describe{
\item{\code{arm}}{name of the treatment arm. }
\item{\code{placebo}}{name of the placebo arm. }
\item{\code{estimate}}{estimate of average treatment effect of \code{arm}. }
\item{\code{p}}{one-sided p-value for between-arm difference (treated vs placebo). }
\item{\code{info}}{sample size used in model with \code{NA} being removed. }
\item{\code{z}}{z statistics of between-arm difference (treated vs placebo). }
}
}
\description{
Fit linear regression model on a continuous endpoint.

Refer to \href{https://zhangh12.github.io/TrialSimulator/articles/wrappers.html}{this vignette}
for more information and examples.
}
