% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qtrunc.R
\name{qtrunc}
\alias{qtrunc}
\alias{qtruncbeta}
\alias{qtruncbinom}
\alias{qtruncchisq}
\alias{qtrunccontbern}
\alias{qtruncexp}
\alias{qtruncgamma}
\alias{qtruncinvgamma}
\alias{qtruncinvgauss}
\alias{qtrunclnorm}
\alias{qtruncnbinom}
\alias{qtruncnorm}
\alias{qtruncpois}
\title{Quantile Function}
\usage{
qtrunc(p, family, ..., lower.tail = TRUE, log.p = FALSE)

qtruncbeta(
  p,
  shape1,
  shape2,
  a = 0,
  b = 1,
  ...,
  lower.tail = TRUE,
  log.p = FALSE
)

qtruncbinom(
  p,
  size,
  prob,
  a = 0,
  b = size,
  ...,
  lower.tail = TRUE,
  log.p = FALSE
)

qtruncchisq(p, df, a = 0, b = Inf, ..., lower.tail = TRUE, log.p = FALSE)

qtrunccontbern(p, lambda, a = 0, b = 1, ..., lower.tail = TRUE, log.p = FALSE)

qtruncexp(p, rate = 1, a = 0, b = Inf, ..., lower.tail = TRUE, log.p = FALSE)

qtruncgamma(
  p,
  shape,
  rate = 1,
  scale = 1/rate,
  a = 0,
  b = Inf,
  ...,
  lower.tail = TRUE,
  log.p = FALSE
)

qtruncinvgamma(
  p,
  shape,
  rate = 1,
  scale = 1/rate,
  a = 0,
  b = Inf,
  ...,
  lower.tail = TRUE,
  log.p = FALSE
)

qtruncinvgauss(p, m, s, a = 0, b = Inf, ..., lower.tail = TRUE, log.p = FALSE)

qtrunclnorm(
  p,
  meanlog = 0,
  sdlog = 1,
  a = 0,
  b = Inf,
  ...,
  lower.tail = TRUE,
  log.p = FALSE
)

qtruncnbinom(
  p,
  size,
  prob,
  mu,
  a = 0,
  b = Inf,
  ...,
  lower.tail = TRUE,
  log.p = FALSE
)

qtruncnorm(
  p,
  mean = 0,
  sd = 1,
  a = -Inf,
  b = Inf,
  ...,
  lower.tail = TRUE,
  log.p = FALSE
)

qtruncpois(p, lambda, a = 0, b = Inf, ..., lower.tail = TRUE, log.p = FALSE)
}
\arguments{
\item{p}{vector of quantiles}

\item{family}{distribution family to use}

\item{...}{\emph{named} distribution parameters and/or truncation limits
(\code{a}, \code{b})}

\item{lower.tail}{logical; if \code{TRUE}, probabilities are
\eqn{P(X <= x)}{P(X \leq x)} otherwise, \eqn{P(X > x)}}

\item{log.p}{logical; if \code{TRUE}, probabilities p are given as \code{log(p)}}

\item{shape1}{positive shape parameter alpha}

\item{shape2}{positive shape parameter beta}

\item{a}{point of left truncation. For discrete distributions, \code{a} will be
included in the support of the truncated distribution.}

\item{b}{point of right truncation}

\item{size}{target for number of successful trials,
or dispersion parameter (the shape parameter of the gamma mixing
distribution). Must be strictly positive, need not be integer.}

\item{prob}{probability of success on each trial}

\item{df}{degrees of freedom for "parent" distribution}

\item{lambda}{mean and var of "parent" distribution}

\item{rate}{inverse gamma rate parameter}

\item{shape}{inverse gamma shape parameter}

\item{scale}{inverse gamma scale parameter}

\item{m}{vector of means}

\item{s}{vector of dispersion parameters}

\item{meanlog}{mean of untruncated distribution}

\item{sdlog}{standard deviation of untruncated distribution}

\item{mu}{alternative parametrization via mean}

\item{mean}{mean of parent distribution}

\item{sd}{standard deviation is parent distribution}
}
\value{
The quantile of \code{p}.
}
\description{
Calculates quantile for a given truncated distribution and
probability.
}
\examples{
qtrunc(0.75)
qtrunc(.2, family = "gaussian", mean = 5, sd = 10, b = 7)
qnorm(.2, mean = 5, sd = 10) # for comparison
}
