% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All.R
\name{GenParetoPars}
\alias{GenParetoPars}
\title{Generalised Pareto distribution parameter estimates}
\usage{
GenParetoPars(x = NULL, L1, LCV, LSKEW)
}
\arguments{
\item{x}{numeric vector. The sample}

\item{L1}{first Lmoment}

\item{LCV}{linear coefficient of variation}

\item{LSKEW}{linear skewness}
}
\value{
Parameter estimates (location, scale, shape)
}
\description{
Estimated parameters from a sample (with Lmoments or maximum likelihood estimation) or from L1 (first L-moment), Lcv (linear coefficient of variation), and LSkew (linear skewness)
}
\details{
The L-moment estimated parameters are by the method detailed in 'Hosking J. and Wallis J. 1997 Regional Frequency Analysis: An Approach Based on L-Moments. Cambridge University Press, New York'.

This function applies a probability distribution model which assumes that the sample data is independent and identical, i.e. the assumption is that all observations in the sample would not impact or depend on any other. Furthermore, all observations are from the same underlying process which has not changed over the period of record (stationarity).
}
\examples{
# Get a peaks over threshold sample and estimate the parameters using L-moments
thames_pot <- POTextract(ThamesPQ[, c(1, 3)], thresh = 0.90)
GenParetoPars(thames_pot$peak)

# Calculate L-moments and estimate the parameters with L1, Lcv, and Lskew
LMoments(thames_pot$peak)

# Store L-moments in an object
l_pars <- as.numeric(LMoments(thames_pot$peak))[c(1, 5, 6)]
GenParetoPars(L1 = l_pars[1], LCV = l_pars[2], LSKEW = l_pars[3])

}
\author{
Anthony Hammond
}
