% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatting.R
\name{rm_extra_DVcols}
\alias{rm_extra_DVcols}
\title{Checks for and removes unnecessary DV output columns.}
\usage{
rm_extra_DVcols(data, Keep = NULL)
}
\arguments{
\item{data}{A data frame object created from an Eyelink Sample Report.}

\item{Keep}{An optional string or character vector containing the column names 
of SR sample report columns the user would like to keep in the data set.}
}
\value{
An object of type data table as described in \link[tibble]{tibble}.
}
\description{
\code{rm_extra_DVcols} checks for unnecessary DataViewer output columns and 
removes them, unless specified.
}
\examples{
\dontrun{
library(VWPre)
df <- rm_extra_DVcols(data = dat, Keep = NULL)
}
}
