% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache.R
\name{BaseCache}
\alias{BaseCache}
\title{Base Cache}
\description{
Abstract base class for cache backends
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{config}}{Cache configuration}

\item{\code{stats}}{Cache statistics}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-BaseCache-new}{\code{BaseCache$new()}}
\item \href{#method-BaseCache-get}{\code{BaseCache$get()}}
\item \href{#method-BaseCache-set}{\code{BaseCache$set()}}
\item \href{#method-BaseCache-delete}{\code{BaseCache$delete()}}
\item \href{#method-BaseCache-exists}{\code{BaseCache$exists()}}
\item \href{#method-BaseCache-clear}{\code{BaseCache$clear()}}
\item \href{#method-BaseCache-size}{\code{BaseCache$size()}}
\item \href{#method-BaseCache-get_many}{\code{BaseCache$get_many()}}
\item \href{#method-BaseCache-set_many}{\code{BaseCache$set_many()}}
\item \href{#method-BaseCache-delete_many}{\code{BaseCache$delete_many()}}
\item \href{#method-BaseCache-make_key}{\code{BaseCache$make_key()}}
\item \href{#method-BaseCache-clone}{\code{BaseCache$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BaseCache-new"></a>}}
\if{latex}{\out{\hypertarget{method-BaseCache-new}{}}}
\subsection{Method \code{new()}}{
Create a new cache
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BaseCache$new(config = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{config}}{CacheConfig object}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BaseCache-get"></a>}}
\if{latex}{\out{\hypertarget{method-BaseCache-get}{}}}
\subsection{Method \code{get()}}{
Get a value from cache
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BaseCache$get(key)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{Cache key}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Cached value or NULL
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BaseCache-set"></a>}}
\if{latex}{\out{\hypertarget{method-BaseCache-set}{}}}
\subsection{Method \code{set()}}{
Set a value in cache
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BaseCache$set(key, value, ttl = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{Cache key}

\item{\code{value}}{Value to cache}

\item{\code{ttl}}{Time to live (optional)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BaseCache-delete"></a>}}
\if{latex}{\out{\hypertarget{method-BaseCache-delete}{}}}
\subsection{Method \code{delete()}}{
Delete a key from cache
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BaseCache$delete(key)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{Cache key}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Logical success
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BaseCache-exists"></a>}}
\if{latex}{\out{\hypertarget{method-BaseCache-exists}{}}}
\subsection{Method \code{exists()}}{
Check if key exists
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BaseCache$exists(key)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{Cache key}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Logical
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BaseCache-clear"></a>}}
\if{latex}{\out{\hypertarget{method-BaseCache-clear}{}}}
\subsection{Method \code{clear()}}{
Clear all cache entries
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BaseCache$clear()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BaseCache-size"></a>}}
\if{latex}{\out{\hypertarget{method-BaseCache-size}{}}}
\subsection{Method \code{size()}}{
Get cache size
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BaseCache$size()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Integer count
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BaseCache-get_many"></a>}}
\if{latex}{\out{\hypertarget{method-BaseCache-get_many}{}}}
\subsection{Method \code{get_many()}}{
Get multiple values
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BaseCache$get_many(keys)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{keys}}{Character vector of keys}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Named list of values
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BaseCache-set_many"></a>}}
\if{latex}{\out{\hypertarget{method-BaseCache-set_many}{}}}
\subsection{Method \code{set_many()}}{
Set multiple values
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BaseCache$set_many(items, ttl = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{items}}{Named list of values}

\item{\code{ttl}}{Time to live}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BaseCache-delete_many"></a>}}
\if{latex}{\out{\hypertarget{method-BaseCache-delete_many}{}}}
\subsection{Method \code{delete_many()}}{
Delete multiple keys
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BaseCache$delete_many(keys)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{keys}}{Character vector of keys}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Integer count of deleted keys
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BaseCache-make_key"></a>}}
\if{latex}{\out{\hypertarget{method-BaseCache-make_key}{}}}
\subsection{Method \code{make_key()}}{
Make a prefixed key
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BaseCache$make_key(key)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{Raw key}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Prefixed key
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BaseCache-clone"></a>}}
\if{latex}{\out{\hypertarget{method-BaseCache-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BaseCache$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
