% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/word_vectors.R
\name{SentenceEmbedder}
\alias{SentenceEmbedder}
\title{Sentence Embedder using Word Vectors}
\description{
Creates sentence embeddings by averaging word vectors with IDF weighting
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{dim}}{Embedding dimension}

\item{\code{vocab_size}}{Vocabulary size}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-SentenceEmbedder-new}{\code{SentenceEmbedder$new()}}
\item \href{#method-SentenceEmbedder-fit}{\code{SentenceEmbedder$fit()}}
\item \href{#method-SentenceEmbedder-embed}{\code{SentenceEmbedder$embed()}}
\item \href{#method-SentenceEmbedder-get_word_vector}{\code{SentenceEmbedder$get_word_vector()}}
\item \href{#method-SentenceEmbedder-has_word}{\code{SentenceEmbedder$has_word()}}
\item \href{#method-SentenceEmbedder-most_similar}{\code{SentenceEmbedder$most_similar()}}
\item \href{#method-SentenceEmbedder-clone}{\code{SentenceEmbedder$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SentenceEmbedder-new"></a>}}
\if{latex}{\out{\hypertarget{method-SentenceEmbedder-new}{}}}
\subsection{Method \code{new()}}{
Create a new SentenceEmbedder
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SentenceEmbedder$new(word_vectors, use_idf = TRUE, smooth_idf = 1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{word_vectors}}{WordVectors object from load_word_vectors()}

\item{\code{use_idf}}{Use IDF weighting (recommended)}

\item{\code{smooth_idf}}{Smoothing for IDF}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SentenceEmbedder-fit"></a>}}
\if{latex}{\out{\hypertarget{method-SentenceEmbedder-fit}{}}}
\subsection{Method \code{fit()}}{
Fit IDF weights on a corpus
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SentenceEmbedder$fit(texts)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{texts}}{Character vector of texts}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SentenceEmbedder-embed"></a>}}
\if{latex}{\out{\hypertarget{method-SentenceEmbedder-embed}{}}}
\subsection{Method \code{embed()}}{
Embed texts to sentence vectors
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SentenceEmbedder$embed(texts)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{texts}}{Character vector of texts}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Matrix of embeddings (rows are sentences)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SentenceEmbedder-get_word_vector"></a>}}
\if{latex}{\out{\hypertarget{method-SentenceEmbedder-get_word_vector}{}}}
\subsection{Method \code{get_word_vector()}}{
Get word vector for a single word
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SentenceEmbedder$get_word_vector(word)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{word}}{Word to look up}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Numeric vector or NULL if not found
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SentenceEmbedder-has_word"></a>}}
\if{latex}{\out{\hypertarget{method-SentenceEmbedder-has_word}{}}}
\subsection{Method \code{has_word()}}{
Check if word is in vocabulary
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SentenceEmbedder$has_word(word)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{word}}{Word to check}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Logical
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SentenceEmbedder-most_similar"></a>}}
\if{latex}{\out{\hypertarget{method-SentenceEmbedder-most_similar}{}}}
\subsection{Method \code{most_similar()}}{
Find most similar words
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SentenceEmbedder$most_similar(word, n = 10)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{word}}{Query word}

\item{\code{n}}{Number of results}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Data frame with word and similarity
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SentenceEmbedder-clone"></a>}}
\if{latex}{\out{\hypertarget{method-SentenceEmbedder-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SentenceEmbedder$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
