% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache.R
\name{VectorCache}
\alias{VectorCache}
\title{Vector Cache}
\description{
Specialized cache for vector search results

Features:
\itemize{
\item Query result caching
\item Vector embedding caching
\item Automatic cache invalidation
}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{prefix}}{Cache key prefix}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-VectorCache-new}{\code{VectorCache$new()}}
\item \href{#method-VectorCache-get_search_results}{\code{VectorCache$get_search_results()}}
\item \href{#method-VectorCache-set_search_results}{\code{VectorCache$set_search_results()}}
\item \href{#method-VectorCache-get_vector}{\code{VectorCache$get_vector()}}
\item \href{#method-VectorCache-set_vector}{\code{VectorCache$set_vector()}}
\item \href{#method-VectorCache-invalidate_vector}{\code{VectorCache$invalidate_vector()}}
\item \href{#method-VectorCache-stats}{\code{VectorCache$stats()}}
\item \href{#method-VectorCache-clone}{\code{VectorCache$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-VectorCache-new"></a>}}
\if{latex}{\out{\hypertarget{method-VectorCache-new}{}}}
\subsection{Method \code{new()}}{
Create a new VectorCache
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VectorCache$new(cache, prefix = "vec:")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{cache}}{Base cache backend}

\item{\code{prefix}}{Key prefix (default: "vec:")}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-VectorCache-get_search_results"></a>}}
\if{latex}{\out{\hypertarget{method-VectorCache-get_search_results}{}}}
\subsection{Method \code{get_search_results()}}{
Get cached search results
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VectorCache$get_search_results(collection, query, filter = NULL, limit = 10)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{collection}}{Collection name}

\item{\code{query}}{Query vector}

\item{\code{filter}}{Filter conditions}

\item{\code{limit}}{Result limit}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Cached results or NULL
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-VectorCache-set_search_results"></a>}}
\if{latex}{\out{\hypertarget{method-VectorCache-set_search_results}{}}}
\subsection{Method \code{set_search_results()}}{
Cache search results
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VectorCache$set_search_results(
  collection,
  query,
  results,
  filter = NULL,
  limit = 10,
  ttl = 300
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{collection}}{Collection name}

\item{\code{query}}{Query vector}

\item{\code{results}}{Search results}

\item{\code{filter}}{Filter conditions}

\item{\code{limit}}{Result limit}

\item{\code{ttl}}{Time to live (default: 300)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-VectorCache-get_vector"></a>}}
\if{latex}{\out{\hypertarget{method-VectorCache-get_vector}{}}}
\subsection{Method \code{get_vector()}}{
Get cached vector
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VectorCache$get_vector(collection, vector_id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{collection}}{Collection name}

\item{\code{vector_id}}{Vector ID}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Cached vector data or NULL
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-VectorCache-set_vector"></a>}}
\if{latex}{\out{\hypertarget{method-VectorCache-set_vector}{}}}
\subsection{Method \code{set_vector()}}{
Cache vector data
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VectorCache$set_vector(collection, vector_id, data, ttl = 3600)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{collection}}{Collection name}

\item{\code{vector_id}}{Vector ID}

\item{\code{data}}{Vector data}

\item{\code{ttl}}{Time to live (default: 3600)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-VectorCache-invalidate_vector"></a>}}
\if{latex}{\out{\hypertarget{method-VectorCache-invalidate_vector}{}}}
\subsection{Method \code{invalidate_vector()}}{
Invalidate cached vector
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VectorCache$invalidate_vector(collection, vector_id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{collection}}{Collection name}

\item{\code{vector_id}}{Vector ID}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-VectorCache-stats"></a>}}
\if{latex}{\out{\hypertarget{method-VectorCache-stats}{}}}
\subsection{Method \code{stats()}}{
Get cache statistics
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VectorCache$stats()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
CacheStats object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-VectorCache-clone"></a>}}
\if{latex}{\out{\hypertarget{method-VectorCache-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VectorCache$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
