% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/database.R
\name{VectrixDB}
\alias{VectrixDB}
\alias{vectrixdb}
\title{VectrixDB Database Class}
\usage{
vectrixdb(path = NULL, storage_type = "memory")
}
\arguments{
\item{path}{Storage path}

\item{storage_type}{Storage type}
}
\value{
VectrixDB object
}
\description{
Main database interface managing collections
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{path}}{Database storage path}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-VectrixDB-new}{\code{VectrixDB$new()}}
\item \href{#method-VectrixDB-create_collection}{\code{VectrixDB$create_collection()}}
\item \href{#method-VectrixDB-get_collection}{\code{VectrixDB$get_collection()}}
\item \href{#method-VectrixDB-list_collections}{\code{VectrixDB$list_collections()}}
\item \href{#method-VectrixDB-delete_collection}{\code{VectrixDB$delete_collection()}}
\item \href{#method-VectrixDB-has_collection}{\code{VectrixDB$has_collection()}}
\item \href{#method-VectrixDB-stats}{\code{VectrixDB$stats()}}
\item \href{#method-VectrixDB-close}{\code{VectrixDB$close()}}
\item \href{#method-VectrixDB-print}{\code{VectrixDB$print()}}
\item \href{#method-VectrixDB-clone}{\code{VectrixDB$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-VectrixDB-new"></a>}}
\if{latex}{\out{\hypertarget{method-VectrixDB-new}{}}}
\subsection{Method \code{new()}}{
Create or open a VectrixDB database
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VectrixDB$new(path = NULL, storage_type = "memory")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{Storage path}

\item{\code{storage_type}}{Storage type ("memory" or "sqlite")}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-VectrixDB-create_collection"></a>}}
\if{latex}{\out{\hypertarget{method-VectrixDB-create_collection}{}}}
\subsection{Method \code{create_collection()}}{
Create a new collection
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VectrixDB$create_collection(
  name,
  dimension,
  metric = "cosine",
  enable_text_index = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Collection name}

\item{\code{dimension}}{Vector dimension}

\item{\code{metric}}{Distance metric}

\item{\code{enable_text_index}}{Enable text indexing}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Collection object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-VectrixDB-get_collection"></a>}}
\if{latex}{\out{\hypertarget{method-VectrixDB-get_collection}{}}}
\subsection{Method \code{get_collection()}}{
Get an existing collection
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VectrixDB$get_collection(name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Collection name}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Collection object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-VectrixDB-list_collections"></a>}}
\if{latex}{\out{\hypertarget{method-VectrixDB-list_collections}{}}}
\subsection{Method \code{list_collections()}}{
List all collections
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VectrixDB$list_collections()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Character vector of collection names
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-VectrixDB-delete_collection"></a>}}
\if{latex}{\out{\hypertarget{method-VectrixDB-delete_collection}{}}}
\subsection{Method \code{delete_collection()}}{
Delete a collection
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VectrixDB$delete_collection(name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Collection name}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-VectrixDB-has_collection"></a>}}
\if{latex}{\out{\hypertarget{method-VectrixDB-has_collection}{}}}
\subsection{Method \code{has_collection()}}{
Check if collection exists
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VectrixDB$has_collection(name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Collection name}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Logical
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-VectrixDB-stats"></a>}}
\if{latex}{\out{\hypertarget{method-VectrixDB-stats}{}}}
\subsection{Method \code{stats()}}{
Get database statistics
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VectrixDB$stats()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
List with stats
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-VectrixDB-close"></a>}}
\if{latex}{\out{\hypertarget{method-VectrixDB-close}{}}}
\subsection{Method \code{close()}}{
Close the database
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VectrixDB$close()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-VectrixDB-print"></a>}}
\if{latex}{\out{\hypertarget{method-VectrixDB-print}{}}}
\subsection{Method \code{print()}}{
Print database summary
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VectrixDB$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-VectrixDB-clone"></a>}}
\if{latex}{\out{\hypertarget{method-VectrixDB-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VectrixDB$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
