% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_data.R
\name{simulate_data}
\alias{simulate_data}
\title{Simulate Daily Virus Incidence Data}
\usage{
simulate_data(
  days = 365,
  peaks = c(flu_a = 90, rsv = 110, sars_cov2 = 160),
  amplitudes = c(flu_a = 50, rsv = 40, sars_cov2 = 20),
  scales = c(flu_a = -0.004, rsv = -0.005, sars_cov2 = -0.001),
  time_offset = 0,
  noise_sd = 5,
  start_date = "2024-01-07"
)
}
\arguments{
\item{days}{Integer. Number of days to simulate (default is 365).}

\item{peaks}{Named numeric vector. Peak day for each virus
(e.g., \code{c("flua"=90,"rsv"=110,"sars_cov2"=160)}).}

\item{amplitudes}{Named numeric vector. Amplitude for each virus's peak
(e.g., \code{c("flua"=50,"rsv"=40,"sars_cov2"=20)}).}

\item{scales}{Named numeric vector. Scale controlling spread of the peak
for each virus (e.g., \code{c("flua"=-0.004,"rsv"=-0.005,"sars_cov2"=-0.001)}).}

\item{time_offset}{Integer. Number of days to offset start of the simulation.
useful if want to test data with larger values in the middle of a respiratory
season.}

\item{noise_sd}{numeric or named numeric.
Gaussian noise applied to each virus signal. can either be a single value
or named for each virus e.g., \code{c("flu_a"=2,"rsv"=5,"sars_cov2"=7)}}

\item{start_date}{string}
}
\value{
A data frame with daily simulated incidence counts for each virus,
including a \code{date} column.
}
\description{
Generates simulated daily incidence data for specified respiratory viruses
over a defined number of days. Each virus is modeled using a Gaussian-like
curve, parameterized by peak day, amplitude, and scale.
}
\examples{
simulate_data()
simulate_data(days = 100, peaks = c(flu_a = 30), amplitudes = c(flu_a = 60),
scales = c(flu_a = -0.01), noise_sd = c(flu_a = 5))
}
