% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miniTools.R
\name{import2}
\alias{import2}
\title{Import two W4M tables}
\usage{
import2(pathDM, pathMeta, typeMeta, disable_comm = TRUE)
}
\arguments{
\item{pathDM}{a path to a file corresponding to the dataMatrix}

\item{pathMeta}{a path to a file corresponding to the metadata table}

\item{typeMeta}{"sample" or "variable" depending on the metadata content}

\item{disable_comm}{a \code{boolean} with default to \code{TRUE} to indicate
whether the comment character \code{#} should be disabled as a comment tag
for the import of the metadata file; when \code{TRUE}, \code{#} in the
metadata table's columns will be considered as any other character.}
}
\value{
a \code{list} containing two elements:
\itemize{
\item dataMatrix a \code{data.frame} corresponding to the imported dataMatrix table;
\item metadata a \code{data.frame} corresponding to the imported metadata table
}
}
\description{
import2
Function to import a metadata table file and its corresponding
dataMatrix file.
import2 performs checks to ensure the identifiers match between
the two tables and stops with an explicit error message in case
identifiers do not match.
}
\examples{
\donttest{

dm_path <- system.file(
  "extdata",
  "mini_datamatrix.txt",
  package="W4MRUtils"
)
meta_path <- system.file(
  "extdata",
  "mini_variablemetadata.txt",
  package="W4MRUtils"
)

## import considering # is not a comment character
A <- W4MRUtils::import2(dm_path, meta_path, "variable")
print(A$dataMatrix[1:5, 1:5])
print(A$metadata[1:5, ])

## import considering # is a comment character
B <- W4MRUtils::import2(dm_path, meta_path, "variable", disable_comm = FALSE)
print(B$dataMatrix[1:5, 1:5])
print(B$metadata[1:5, ])
}

}
\author{
M.Petera
}
