% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdf.cox.R
\name{cdf.cox}
\alias{cdf.cox}
\title{\insertCite{cox2005;textual}{WData} distribution estimator}
\usage{
cdf.cox(
  y,
  w = function(y) {
     ifelse(y >= 0, y, NA)
 }
)
}
\arguments{
\item{y}{A numeric vector containing the biased sample.}

\item{w}{A function representing the bias function applied to the data points. It must be evaluable and positive in each point of the sample \code{y}. By default, it is set to the length-biased function.}
}
\value{
A function of class \code{ecdf}, inheriting from the \code{\link[stats:stepfun]{stepfun}} class, and hence inheriting a \code{\link[stats:stepfun]{knots}} method.
}
\description{
This function computes \insertCite{cox2005;textual}{WData} distribution estimator given a sample and the corresponding biased function.
}
\details{
\insertCite{cox2005;textual}{WData} distribution estimator is expressed as
\deqn{\widehat{F}_n(y) = \frac{\widehat{\mu}_w}{n}\sum_{i=1}^{n} \frac{1}{w(Y_i)} \mathbb{I}(Y_i \leq y),
\quad \text{where} \quad
\widehat{\mu}_w = n \left(\sum_{i=1}^{n} \frac{1}{w(Y_i)} \right)^{-1}.}
}
\examples{
cdf.cox(y = shrub.data$Width)
}
\references{
\insertAllCited{}
}
