% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export.R
\name{export_to_json}
\alias{export_to_json}
\title{Helper function to convert export list to JSON}
\usage{
export_to_json(export_list, format, file = NULL, pretty = TRUE)
}
\arguments{
\item{export_list}{The list to convert to JSON. Must contain variables, parameters, and arcs components, see details.}

\item{format}{Character string specifying the export format. Currently, only
\code{"json"} is supported.}

\item{file}{Optional character string specifying a file path to save the JSON
output. If \code{NULL} (default), the JSON string is returned.}

\item{pretty}{Logical, whether to format the JSON output with indentation for
readability. Default is \code{TRUE}. Set to \code{FALSE} for more compact output.}
}
\description{
Helper function to convert export list to JSON
}
\details{
The export_list must be a named list with the following components:
\itemize{
\item scenario_id: Optional identifier for the model run/scenario.
\item label: Optional name/label for the scenario.
\item variables: An array where each element represents a variable/node with its metadata, distribution type, and states (for categorical variables).
\item parameters: An array where each element represents a parameter with its link function, source variable, and coefficients.
\item arcs: An array with arc details, each containing source_variable_id and target_variable_id.
}
}
\keyword{internal}
