% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assertions.R
\name{assert_same_type}
\alias{assert_same_type}
\title{Are All Arguments of the Same Type?}
\usage{
assert_same_type(
  ...,
  .message = c("Arguments {.arg {arg_names}} must be the same type.", i =
    paste("Argument types are", paste0("{.arg ", arg_names, "} {.cls ", types, "}",
    collapse = ", "))),
  .class = "assert_same_type",
  .call = parent.frame()
)
}
\arguments{
\item{...}{Arguments to be checked

\describe{
\item{Default value}{none}
}}

\item{.message}{character vector passed to \code{cli_abort(message)} when assertion fails.

\describe{
\item{Default value}{\code{c("Arguments {.arg {arg_names}} must be the same type.", i = paste(
  "Argument types are", paste0("{.arg ", arg_names, "} {.cls ", types, "}",
    collapse = ", ")))}}
}}

\item{.class}{character vector passed to \code{cli_abort(class)} when assertion fails.

\describe{
\item{Default value}{\code{"assert_same_type"}}
}}

\item{.call}{environment passed to \code{cli_abort(call)} when assertion fails.

\describe{
\item{Default value}{\code{parent.frame()}}
}}
}
\value{
The function throws an error if not all arguments are of the same type.
}
\description{
Checks if all arguments are of the same type.
}
\examples{
example_fun <- function(true_value, false_value, missing_value) {
  assert_same_type(true_value, false_value, missing_value)
}

example_fun(
  true_value = "Y",
  false_value = "N",
  missing_value = NA_character_
)

try(example_fun(
  true_value = 1,
  false_value = 0,
  missing_value = "missing"
))
}
\seealso{
Checks for valid input and returns warning or errors messages:
\code{\link{assert_atomic_vector}()},
\code{\link{assert_character_scalar}()},
\code{\link{assert_character_vector}()},
\code{\link{assert_data_frame}()},
\code{\link{assert_date_vector}()},
\code{\link{assert_expr}()},
\code{\link{assert_expr_list}()},
\code{\link{assert_filter_cond}()},
\code{\link{assert_function}()},
\code{\link{assert_integer_scalar}()},
\code{\link{assert_list_element}()},
\code{\link{assert_list_of}()},
\code{\link{assert_logical_scalar}()},
\code{\link{assert_named}()},
\code{\link{assert_numeric_vector}()},
\code{\link{assert_one_to_one}()},
\code{\link{assert_param_does_not_exist}()},
\code{\link{assert_s3_class}()},
\code{\link{assert_symbol}()},
\code{\link{assert_unit}()},
\code{\link{assert_vars}()},
\code{\link{assert_varval_list}()}
}
\concept{assertion}
\keyword{assertion}
