% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alsi.R
\name{alsi_workflow}
\alias{alsi_workflow}
\title{Complete ALSI Analysis Workflow}
\usage{
alsi_workflow(
  data,
  vars,
  B_pa = 2000,
  B_boot = 2000,
  q = 0.95,
  seed = 20260123
)
}
\arguments{
\item{data}{Data frame or path to .xlsx file}

\item{vars}{Character vector of binary variable names}

\item{B_pa}{Number of permutations for parallel analysis (default: 2000)}

\item{B_boot}{Number of bootstrap resamples (default: 2000)}

\item{q}{Quantile for parallel analysis (default: 0.95)}

\item{seed}{Random seed for reproducibility}
}
\value{
List (returned invisibly) containing all analysis objects:
  \item{pa}{Parallel analysis results (class \code{mca_pa})}
  \item{boot}{Bootstrap stability results (class \code{mca_bootstrap})}
  \item{fit}{MCA fit object (class \code{mca_fit})}
  \item{alsi}{ALSI values (class \code{alsi})}
  \item{K}{Number of dimensions retained based on parallel analysis}
}
\description{
Runs a complete ALSI analysis including parallel analysis for dimensionality
assessment, bootstrap stability evaluation, ALSI computation, and visualization.
}
\examples{
\donttest{
data(ANR2)
vars <- c("MDD", "DYS", "DEP", "PTSD", "OCD", "GAD", "ANX", "SOPH", "ADHD")
results <- alsi_workflow(
  data   = ANR2,
  vars   = vars,
  B_pa   = 100,
  B_boot = 100
)
results$pa
results$boot
results$alsi
}
}
