% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior.R
\name{posterior_probability}
\alias{posterior_probability}
\title{Posterior probability of significance}
\usage{
posterior_probability(mid_samples)
}
\arguments{
\item{mid_samples}{Numeric vector of indicator draws (0/1)}
}
\value{
Numeric probability
}
\description{
Computes the posterior probability that the target parameter
exceeds the threshold for significance.
}
\examples{
# Simulated posterior draws
set.seed(123)
mid_samples <- rnorm(2000, mean = -0.3, sd = 0.1)

# Posterior probability of benefit
posterior_probability(mid_samples)

}
\references{
Kabali C (2025). AppRaise: Software for quantifying evidence uncertainty
in systematic reviews using a posterior mixture model. \emph{Journal of
Evaluation in Clinical Practice}, 31, 1-12. https://doi.org/10.1111/jep.70272.
}
\seealso{
\itemize{
\item \code{\link{posterior_mixture}}
\item \code{vignette("appraise-introduction")}
}
}
