% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/growth.R
\name{sgr}
\alias{sgr}
\title{Specific Growth Rate (SGR)}
\usage{
sgr(ibw, fbw, duration, return_igr = FALSE)
}
\arguments{
\item{ibw}{numeric; value that is providing the initial body weight in
grams.}

\item{fbw}{numeric; value that is providing the final body weight in
grams.}

\item{duration}{numeric value that is providing the duration of the
experiment in days.}

\item{return_igr}{logical; default is FALSE. Indicates whether the 
instantaneous growth rate shall be returned together with the SGR or not.}
}
\value{
Returns a numeric, which is the SGR as percentage of the body
weight gain per day, or a list containing the SGR and the IGR.
}
\description{
This function calculates the Specific Growth Rate (SGR) based on
the Instantaneous Growth Rate (IGR). The IGR is a useful
metric, although hard to interpret. The SGR, derived from IGR, can then be 
easily interpreted as the percentage of Body Weight gained each day.
The SGR is a growth metric for aquaculture products (e.g., fish,
crustaceans, bivalves, algae), describing the increase in body weight over
a period of time. Body weight can be substituted by other metrics,
such as length. However, body weight is the used in the vast majority
of studies and alternatives are not advised for the sake of consistency.
}
\examples{
dplyr::mutate(weight2, SGR = sgr(ibw_g, fbw_g, duration = 84))

}
\references{
Crane, D.P., Ogle, D.H. and Shoup, D.E. (2020), Use and misuse
of a common growth metric: guidance for appropriately calculating and
reporting specific growth rate. Rev Aquacult, 12: 1542-1547.
https://doi.org/10.1111/raq.12396
}
\author{
Anıl Axel Tellbüscher

Davide A. Machado e Silva
}
