% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arc-read.R
\name{encode_field_values}
\alias{encode_field_values}
\title{Encode Domain Values}
\usage{
encode_field_values(
  .data,
  .layer,
  field = NULL,
  codes = c("replace", "label"),
  call = rlang::caller_env()
)
}
\arguments{
\item{.data}{A data frame returned by \code{arc_select()} or \code{arc_read()}.}

\item{.layer}{A Table or FeatureLayer object. Required.}

\item{field}{Optional character vector with names of fields to replace.
Fields that do not have coded value domains are ignored. Defaults to \code{NULL}
to replace or label all fields with coded value domains.}

\item{codes}{Use of field alias values. Defaults to \code{"replace"}.
There are two options:
\itemize{
\item \code{"replace"}: coded values replace existing column values.
\item \code{"label"}: coded values are applied as value labels via a \code{"label"} attribute.
}}

\item{call}{The execution environment of a currently
running function, e.g. \code{caller_env()}. The function will be
mentioned in error messages as the source of the error. See the
\code{call} argument of \code{\link[rlang:abort]{abort()}} for more information.}
}
\value{
A data.frame with fields encoded with their respective domains.
}
\description{
\code{\link[=encode_field_values]{encode_field_values()}} can replace column values based on \code{codedValue}
type field domains from a corresponding \code{Table} or \code{FeatureLayer} object
created with \code{arc_open()}.
}
\examples{
\donttest{
layer <- arc_open(
  "https://geodata.baltimorecity.gov/egis/rest/services/Housing/dmxOwnership/MapServer/0"
)

res <- arc_select(
  layer,
  n_max = 100,
  where = "RESPAGCY <> '  '",
  fields = "RESPAGCY"
)
encoded <- encode_field_values(res, layer)
table(encoded$RESPAGCY)
}
}
