% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{land}
\alias{land}
\title{Global Land Mask}
\format{
An \code{sf} data frame with 1 row:
\describe{
\item{name}{Description ("Global Land")}
\item{geometry}{Land multipolygon in WGS84 (EPSG:4326)}
}
}
\source{
Natural Earth \url{https://www.naturalearthdata.com/}
}
\usage{
land
}
\description{
An \code{sf} object containing the global land polygon from Natural Earth (1:50m scale).
Used for masking area of effect computations to exclude ocean areas.
}
\examples{
# Use as mask to exclude sea
\donttest{
dummy <- sf::st_as_sf(
  data.frame(id = 1),
  geometry = sf::st_sfc(sf::st_point(c(14.5, 47.5))),
  crs = 4326
)
result <- aoe(dummy, "AT", mask = land)
}

}
\keyword{datasets}
