% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert_numerical.R
\name{assert_all_finite}
\alias{assert_all_finite}
\title{Assert that all values are finite}
\usage{
assert_all_finite(x, msg = NULL, call = rlang::caller_env(), arg_name = NULL)
}
\arguments{
\item{x}{An object}

\item{msg}{The error message thrown if the assertion fails (string)}

\item{call}{Only relevant when pooling assertions into multi-assertion helper functions. See \link[cli]{cli_abort} for details.}

\item{arg_name}{Advanced use only. Name of the argument passed (default: NULL, will automatically extract arg_name).}
}
\value{
invisible(TRUE) if all values in \code{x} are finite, otherwise aborts with the error message specified by \code{msg}
}
\description{
Check that all values in \code{x} are finite (not \code{NA}, \code{NaN}, \code{Inf}, or \code{-Inf}).
}
\examples{
try({
assert_all_finite(c(1, 2, 3)) # Passes
assert_all_finite(c(1, Inf)) # Throws error
})

}
\concept{assert_numerical}
