% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/document.R
\name{am_get_actor}
\alias{am_get_actor}
\title{Get the actor ID of a document}
\usage{
am_get_actor(doc)
}
\arguments{
\item{doc}{An Automerge document}
}
\value{
A raw vector containing the actor ID bytes
}
\description{
Returns the actor ID of an Automerge document as a raw vector.
The actor ID uniquely identifies the editing session that created
changes in the document.
}
\details{
For a hex string representation, use \code{\link[=am_get_actor_hex]{am_get_actor_hex()}}.
}
\examples{
doc <- am_create()
actor <- am_get_actor(doc)

# Use am_get_actor_hex() for display
actor_hex <- am_get_actor_hex(doc)
cat("Actor ID:", actor_hex, "\n")
}
