% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objects.R
\name{am_list_range}
\alias{am_list_range}
\title{Get a range of list items}
\usage{
am_list_range(doc, obj, begin, end, heads = NULL)
}
\arguments{
\item{doc}{An Automerge document}

\item{obj}{An Automerge object ID (must be a list)}

\item{begin}{Start index (1-based, inclusive)}

\item{end}{End index (1-based, inclusive)}

\item{heads}{Optional list of change hashes (raw vectors) for historical
query. If \code{NULL} (default), uses the current state.}
}
\value{
A list of values in the index range.
}
\description{
Returns list elements within the index range \verb{[begin, end]}.
Uses 1-based indexing consistent with R conventions.
}
\examples{
doc <- am_create()
doc$items <- list("a", "b", "c", "d", "e")
items <- doc$items

# Get elements 2 through 4 -> "b", "c", "d"
range <- am_list_range(doc, items, 2, 4)
range

am_close(doc)

}
