% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objects.R
\name{am_map_get_all}
\alias{am_map_get_all}
\title{Get all conflicting values at a map key}
\usage{
am_map_get_all(doc, obj, key, heads = NULL)
}
\arguments{
\item{doc}{An Automerge document}

\item{obj}{An Automerge object ID (must be a map), or \code{AM_ROOT}}

\item{key}{Character string key}

\item{heads}{Optional list of change hashes (raw vectors) for historical
query. If \code{NULL} (default), uses the current state.}
}
\value{
A list of all values at the key. Returns an empty list if the key
does not exist.
}
\description{
Returns all values stored at a map key, including conflicts from concurrent
edits by different actors. When there are no conflicts, the list contains
a single element (the winning value).
}
\examples{
doc <- am_create()
doc$key <- "value"

# Single value (no conflict)
values <- am_map_get_all(doc, AM_ROOT, "key")
values

am_close(doc)

}
