% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_predictions.R
\name{combine_obs_with_pred}
\alias{combine_obs_with_pred}
\title{Combine observed data with a single prediction draw}
\usage{
combine_obs_with_pred(
  predicted_counts,
  reporting_triangle,
  ref_time_aggregator = identity,
  delay_aggregator = function(x) rowSums(x, na.rm = TRUE)
)
}
\arguments{
\item{predicted_counts}{Vector of predicted counts at each reference date.
Note that if using a reference time or delay aggregator function, this
is assumed to have already been aggregated.}

\item{reporting_triangle}{A \link{reporting_triangle} object with rows
representing reference times and columns representing delays.
Can be a reporting matrix or incomplete reporting matrix.
Can also be a ragged reporting triangle, where multiple columns are
reported for the same row (e.g., weekly reporting of daily data).}

\item{ref_time_aggregator}{Function that operates along the rows (reference
times) of the retrospective point nowcast matrix before it has been
aggregated across columns (delays). Default is \code{identity}
which does not aggregate across reference times.}

\item{delay_aggregator}{Function that operates along the columns (delays)
of the retrospective point nowcast matrix after it has been aggregated
across reference times. Default is \code{function(x) rowSums(x, na.rm = TRUE)}.}
}
\value{
A vector of predicted counts at each reference date, for all
reference dates in the input \code{reporting_triangle} (or fewer if using
\code{ref_time_aggregator})
}
\description{
Internally it sums observed counts from the reporting triangle by reference
time and adds them to the predicted counts to form a single draw of the
nowcast for the final counts by reference time.
}
\examples{
# Use example data
reporting_triangle <- apply_reporting_structure(example_reporting_triangle)
pred_counts <- c(10, 20, 30, 40)
combine_obs_with_pred(pred_counts, reporting_triangle)

# Example with rolling sum
if (requireNamespace("zoo", quietly = TRUE)) {
  combine_obs_with_pred(pred_counts,
    reporting_triangle,
    ref_time_aggregator = function(x) zoo::rollsum(x, k = 2, align = "right")
  )
}
}
\seealso{
Probabilistic nowcast generation functions
\code{\link{sample_nb}()},
\code{\link{sample_nowcast}()},
\code{\link{sample_nowcasts}()},
\code{\link{sample_prediction}()},
\code{\link{sample_predictions}()}
}
\concept{generate_probabilistic_nowcasts}
