% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc_utils.R
\name{mcmc_to_dataframe}
\alias{mcmc_to_dataframe}
\title{Convert MCMC Parameters to Data Frame}
\usage{
mcmc_to_dataframe(mcmc_results)
}
\arguments{
\item{mcmc_results}{The results object returned by \code{runMCMC()}.
Must contain a \code{Parameters} component and a \code{LogLikelihood} component.}
}
\value{
A data frame with one row per MCMC iteration containing:
\itemize{
\item \code{iteration}: The iteration number
\item \code{insitu_*}: In-situ probability parameters
\item \code{surv_test_*}: Surveillance test parameters
\item \code{clin_test_*}: Clinical test parameters and rates
\item \code{outunit_*}: Out of unit infection parameters
\item \code{inunit_*}: In unit LinearAbx model parameters (base, time, mass, freq, colabx, susabx, susever, clr, clrAbx, clrEver)
\item \code{abxrate_*}: Antibiotic rate parameters
\item \code{loglikelihood}: Log likelihood at each iteration
}
}
\description{
Converts the nested list structure of MCMC parameters from \code{runMCMC}
output into a tidy data frame format suitable for analysis and visualization.
}
\details{
The function extracts parameters from the nested list structure and handles
missing values gracefully by inserting \code{NA} when a parameter is not present.
This is particularly useful for creating trace plots and posterior distributions.
}
\examples{
results <- runMCMC(data = simulated.data,
                   modelParameters = LinearAbxModel(),
                   nsims = 10,
                   nburn = 0,
                   outputparam = TRUE,
                   outputfinal = FALSE)
param_df <- mcmc_to_dataframe(results)
head(param_df)
}
