% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bids.R
\name{create_smooth_transformer}
\alias{create_smooth_transformer}
\title{Create a simple smoothing transformer}
\usage{
create_smooth_transformer(fwhm, suffix_pattern = "bold\\\\.nii")
}
\arguments{
\item{fwhm}{The smoothing FWHM to add to the description.}

\item{suffix_pattern}{Optional regex pattern to match specific file types.}
}
\value{
A transformer function for use with \code{\link{bids_transform}}.
}
\description{
This creates a transformer function that adds a smoothing description to
BIDS filenames. This is a lightweight example - real implementations would
perform actual image processing.
}
\examples{
\donttest{
# Create a smoothing transformer
smooth_6mm <- create_smooth_transformer(6)

# Apply it to a toy BIDS-like file path
in_dir <- tempdir()
out_dir <- tempdir()
infile <- file.path(in_dir, "sub-01_task-rest_bold.nii.gz")
file.create(infile)
new_file <- smooth_6mm(infile, out_dir)
basename(new_file)
unlink(infile)
unlink(new_file)
}
}
