% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/est_between.R
\name{est_between}
\alias{est_between}
\title{Estimate between-block parameters}
\usage{
est_between(
  formula,
  network,
  add_intercepts = TRUE,
  clustering_with_features = FALSE
)
}
\arguments{
\item{formula}{An \R \code{\link{formula}} object of the form
\code{y ~ <model terms>}, where \code{y} is a
\code{\link[network]{network}} object.
The network object must contain block information as a vertex attribute with the name 'block'.
For the details on the possible \code{<model terms>}, see
\code{\link[ergm]{ergmTerm}} and Morris, Handcock and Hunter (2008).
All terms that induce dependence are excluded from the between block model.}

\item{network}{a network object with one vertex attribute called 'block' representing which node belongs to which block}

\item{add_intercepts}{Boolean value to indicate whether adequate intercepts
should be added to the provided formula so that the model in the first stage
of the estimation is a nested model of the estimated model in the second stage of the estimation}

\item{clustering_with_features}{Boolean value to indicate if the clustering
was carried out making use of the covariates or not (only important if \code{add_intercepts = TRUE})}
}
\value{
'ergm' object of the estimated model.
}
\description{
Function to estimate the between-block model by relying on the maximum likelihood estimator.
}
\examples{
adj <- c(
c(0, 1, 0, 0, 1, 0),
c(1, 0, 1, 0, 0, 1),
c(0, 1, 0, 1, 1, 0),
c(0, 0, 1, 0, 1, 1),
c(1, 0, 1, 1, 0, 1),
c(0, 1, 0, 1, 1, 0)
)
adj <- matrix(data = adj, nrow = 6, ncol = 6)
rownames(adj) <- as.character(1001:1006)
colnames(adj) <- as.character(1001:1006)

# Use non-consecutive block names
block <- c(50, 70, 95, 50, 95, 70)
g <- network::network(adj, matrix.type = "adjacency")
g \%v\% "block" <- block
est <- est_between(
  formula = g ~ edges,network = g,
  add_intercepts = FALSE, clustering_with_features = FALSE
)
}
\references{
Morris M, Handcock MS, Hunter DR (2008). Specification of Exponential-Family Random Graph Models: Terms and Computational Aspects.
Journal of Statistical Software, 24.
}
