% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_estimation.R
\name{get_deltamethod_std_err}
\alias{get_deltamethod_std_err}
\title{Get standard errors using delta method}
\usage{
get_deltamethod_std_err(
  fit_is_lq,
  variable = c("dose", "fraction_partial", "fraction_hetero"),
  mean_estimate,
  cov_estimate,
  protracted_g_value = NA,
  d0 = NA
)
}
\arguments{
\item{fit_is_lq}{Whether the fit is linear quadratic (\code{TRUE}) or linear (\code{FALSE}).}

\item{variable}{Variable resulting of the transformation \eqn{g(X)}.}

\item{mean_estimate}{The estimated mean of \eqn{X}.}

\item{cov_estimate}{The estimated covariance matrix of \eqn{X}.}

\item{protracted_g_value}{Protracted \eqn{G(x)} value.}

\item{d0}{Survival coefficient of irradiated cells.}
}
\value{
Numeric value containing the standard error of the dose estimate.
}
\description{
Delta method for approximating the standard error of a transformation \eqn{g(X)} of a random variable \eqn{X = (x1, x2, ...)}, given estimates of the mean and covariance matrix of \eqn{X}.
}
