% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bf_analyze.R
\name{bf_analyze}
\alias{bf_analyze}
\title{Analyze encoding options for data}
\usage{
bf_analyze(
  x,
  range = NULL,
  decimals = NULL,
  min_bits = NULL,
  max_bits = 16L,
  fields = NULL,
  plot = FALSE
)
}
\arguments{
\item{x}{A numeric, integer, logical, factor, character vector, or single
layer SpatRaster to analyze. The type is auto-detected.}

\item{range}{\code{\link[=numeric]{numeric(2)}}\cr optional target range \code{c(min,
  max)} to design for (float analysis only). Defaults to the actual data
range.}

\item{decimals}{\code{\link[=integer]{integer(1)}}\cr optional decimal places of
precision required (float analysis only).}

\item{min_bits}{\code{\link[=integer]{integer(1)}}\cr minimum total bits to display in
the Pareto table output. Configurations with fewer bits are hidden. Default
is \code{NULL} (show all).}

\item{max_bits}{\code{\link[=integer]{integer(1)}}\cr maximum total bits to consider.
Defaults to 16.}

\item{fields}{\code{\link{list}}\cr optional list specifying which configurations
to analyze (float analysis only). See Details.}

\item{plot}{\code{\link[=logical]{logical(1)}}\cr whether to generate a plot (float
analysis only). Default is \code{FALSE}.}
}
\value{
An object of class \code{bf_analysis} with analysis results.
}
\description{
This function helps you choose appropriate bit allocations for encoding data.
It auto-detects the data type and provides relevant analysis:
\itemize{
\item Numeric with decimals: trade-offs for floating point encoding, which
exponent/significand combinations are adequate for your range and
precision requirements.
\item Integer: (signed) integer encoding, how many bits are required.
\item Factor/character: category/enumeration encoding, which levels are in
the data and how many bits are required
\item Logical: boolean encoding, do NA values require a second bit.
}
}
\details{
All of this can be applied both to columns in a table or layers in a
SpatRaster. Use this before \code{\link{bf_map}} to understand your encoding
options.
}
\section{Float analysis output}{

For numeric (float) data, the output table shows Pareto-optimal
exponent/significand configurations. The columns are:
\describe{
\item{Exp, Sig, Total}{Number of exponent bits, significand bits, and
their sum. More exponent bits extend the representable range (at the cost
of coarser resolution), while more significand bits improve resolution
within each exponent band.}
\item{Underflow}{Percentage of data values that fall below the smallest
representable positive value. These values are rounded to zero.}
\item{Overflow}{Percentage of data values that exceed the largest
representable value. These values are clipped to the maximum.}
\item{Changed}{Percentage of data values that change when encoded and
decoded (i.e., that do not survive the round-trip exactly).}
\item{Min Res, Max Res}{Smallest and largest step size between adjacent
representable values. In minifloat encoding, resolution varies across the
range: small values near zero have fine resolution (small steps), while
large values have coarse resolution (large steps). A Max Res of 1.0 means
that in the coarsest region, only integer values can be represented --
continuous input will be rounded to whole numbers.}
\item{RMSE}{Root mean squared error between original and decoded values,
computed over all non-NA data points.}
\item{Max Err}{Largest absolute difference between any original value and
its decoded counterpart.}
}
}

\section{Choosing a configuration}{

The table only shows Pareto-optimal configurations, i.e., those where no
other configuration is strictly better on all quality metrics for the same
or fewer total bits. To choose between them:
\itemize{
\item Check \strong{Underflow} and \strong{Overflow} first. Non-zero values
indicate data loss at the extremes of your range. Adding exponent bits
or using the \code{range} argument to widen the target range can help.
\item Compare \strong{RMSE} and \strong{Max Err} to your acceptable
precision. If you specified \code{decimals}, look for configurations
where Max Res is at most \code{10^(-decimals)}.
\item If \strong{Max Res} is >= 1, decoded values in the upper range will
appear as integers even if the input was continuous. This may or may not
be acceptable depending on your application.
}
}

\section{Specifying configurations with \code{fields}}{

By default, all combinations up to \code{max_bits} are evaluated and only
the Pareto front is shown. Use the \code{fields} argument to instead compare
specific configurations:
\itemize{
\item \code{fields = list(exponent = 4)} shows all significand values
paired with 4 exponent bits.
\item \code{fields = list(exponent = c(3, 4), significand = c(5, 4))}
compares exp=3/sig=5 and exp=4/sig=4.
}
}

\examples{
# float analysis (numeric with decimals)
bf_analyze(bf_tbl$yield)

# with specific decimal precision requirement
bf_analyze(bf_tbl$yield, decimals = 2)

# design for a larger range than current data
bf_analyze(bf_tbl$yield, range = c(0, 20))

# with visualization
bf_analyze(bf_tbl$yield, decimals = 2, plot = TRUE)

# compare specific configurations
bf_analyze(bf_tbl$yield, fields = list(exponent = c(2, 3, 4), significand = c(5, 4, 3)))

# show all combinations for a specific exponent
bf_analyze(bf_tbl$yield, fields = list(exponent = 4))

# integer analysis
bf_analyze(as.integer(c(0, 5, 10, 100)))

# category/enum analysis
bf_analyze(bf_tbl$commodity)

# boolean analysis
bf_analyze(c(TRUE, FALSE, TRUE, NA))

# raster with attribute table
library(terra)
r <- rast(nrows = 3, ncols = 3, vals = c(0, 1, 2, 0, 1, 2, 0, 1, 2))
levels(r) <- data.frame(id = 0:2, label = c("low", "medium", "high"))
bf_analyze(r)

}
