% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bf_flag.R
\name{bf_flag}
\alias{bf_flag}
\title{Build a flag}
\usage{
bf_flag(registry, flag = NULL)
}
\arguments{
\item{registry}{\code{\link[=registry]{registry(1)}}\cr an already defined bitfield
registry.}

\item{flag}{\code{\link[=character]{character(1)}}\cr name of the flag to build.}
}
\value{
vector of the flag values.
}
\description{
Convert a flag specification into actual flag values
}
\details{
This function extracts the flag specification, including its test to
call it on the data from which the flag shall be created.
}
\examples{
reg <- bf_registry(name = "testBF", description = "test bitfield",
                   template = bf_tbl)
reg <- bf_map(protocol = "na", data = bf_tbl, registry = reg,
              x = year)
str(reg@flags)

bf_flag(registry = reg, flag = "na_year")
}
