% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/board-class.R, R/board-option.R,
%   R/board-options.R
\name{board_ctor}
\alias{board_ctor}
\alias{new_board_option}
\alias{is_board_option}
\alias{validate_board_option}
\alias{as_board_option}
\alias{as_board_option.board_option}
\alias{board_option_id}
\alias{board_option_trigger}
\alias{board_option_default}
\alias{board_option_category}
\alias{board_option_ui}
\alias{board_option_server}
\alias{board_option_transform}
\alias{board_option_value}
\alias{board_option_ctor}
\alias{validate_board_option.default}
\alias{new_board_name_option}
\alias{new_n_rows_option}
\alias{new_page_size_option}
\alias{new_filter_rows_option}
\alias{new_thematic_option}
\alias{new_dark_mode_option}
\alias{new_show_conditions_option}
\alias{new_llm_model_option}
\alias{new_board_options}
\alias{default_board_options}
\alias{is_board_options}
\alias{as_board_options}
\alias{as_board_options.board_options}
\alias{as_board_options.board_option}
\alias{as_board_options.list}
\alias{as_board_options.board}
\alias{validate_board_options}
\alias{board_option_values}
\alias{get_board_option_value}
\alias{set_board_option_value}
\alias{get_board_option_or_default}
\alias{get_board_option_or_null}
\alias{get_board_option_values}
\alias{combine_board_options}
\title{Board options}
\usage{
board_ctor(x)

new_board_option(
  id,
  default,
  ui,
  server = function(board, ..., session) {
 },
  update_trigger = id,
  transform = identity,
  category = NULL,
  ctor = sys.parent(),
  pkg = NULL
)

is_board_option(x)

validate_board_option(x)

as_board_option(x, ...)

\method{as_board_option}{board_option}(x, ...)

board_option_id(x)

board_option_trigger(x)

board_option_default(x)

board_option_category(x)

board_option_ui(x, id = NULL)

board_option_server(x, ...)

board_option_transform(x)

board_option_value(x, value = board_option_default(x))

board_option_ctor(x)

\method{validate_board_option}{default}(x)

new_board_name_option(value = NULL, category = "Board options", ...)

new_n_rows_option(
  value = blockr_option("n_rows", 50L),
  category = "Table options",
  ...
)

new_page_size_option(
  value = blockr_option("page_size", 5L),
  category = "Table options",
  ...
)

new_filter_rows_option(
  value = blockr_option("filter_rows", FALSE),
  category = "Table options",
  ...
)

new_thematic_option(
  value = blockr_option("thematic", NULL),
  category = "Theme options",
  ...
)

new_dark_mode_option(
  value = blockr_option("dark_mode", NULL),
  category = "Theme options",
  ...
)

new_show_conditions_option(
  value = blockr_option("show_conditions", c("warning", "error")),
  category = "Board options",
  ...
)

new_llm_model_option(value = NULL, category = "Board options", ...)

new_board_options(...)

default_board_options(...)

is_board_options(x)

as_board_options(x)

\method{as_board_options}{board_options}(x)

\method{as_board_options}{board_option}(x)

\method{as_board_options}{list}(x)

\method{as_board_options}{board}(x)

validate_board_options(x)

board_option_values(x)

get_board_option_value(opt, session = get_session())

set_board_option_value(opt, val, session = get_session())

get_board_option_or_default(
  opt,
  opts = default_board_options(),
  session = get_session()
)

get_board_option_or_null(opt, session = get_session())

get_board_option_values(
  ...,
  opts = default_board_options(),
  if_not_found = c("error", "default", "null"),
  session = get_session()
)

combine_board_options(...)
}
\arguments{
\item{x}{Board options object}

\item{id}{Board option ID}

\item{default}{Default value}

\item{ui}{Option UI}

\item{server}{(Optional) option server}

\item{update_trigger}{Shiny \code{input} entry/entries that trigger an update}

\item{transform}{(Optional) transform function}

\item{category}{(Optional) string-valued category}

\item{ctor, pkg}{Constructor information (used for serialization)}

\item{...}{Options passed as individual arguments}

\item{value}{Option value}

\item{opt}{Option name}

\item{session}{Shiny session}

\item{val}{New value}

\item{opts}{Board options}

\item{if_not_found}{Behavior in case an option is not found}
}
\value{
All of \code{new_board_options()} and \code{as_board_options()} return a
\code{board_options} object, as does the validator \code{validate_board_options()},
which is typically called for side effects of throwing errors is validation
does not pass. Inheritance checking as \code{is_board_options()} returns a scalar
logical, while \code{board_option_values()} returns a named list of option values.
}
\description{
User settings at the board level are managed by a \code{board_options} object.
This can be constructed via \code{new_board_options()} and in case the set of
user options is to be extended, the constructor is designed with sub-classing
in mind. Consequently, the associated validator \code{validate_board_options()}
is available as S3 generic. Inheritance checking is available as
\code{is_board_options()} and coercion as \code{as_board_options()}.
}
\examples{
opt <- new_board_options(
   new_board_name_option(),
   new_page_size_option()
 )

is_board_options(opt)
names(opt)

opt[["page_size"]]

}
