% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file-block.R, R/file-browser.R, R/file-upload.R
\name{new_file_block}
\alias{new_file_block}
\alias{new_filebrowser_block}
\alias{filebrowser_volumes}
\alias{new_upload_block}
\title{File block constructors}
\usage{
new_file_block(server, ui, class, ctor = sys.parent(), ...)

new_filebrowser_block(
  file_path = character(),
  volumes = filebrowser_volumes(),
  ...
)

filebrowser_volumes(default = c(home = path.expand("~")))

new_upload_block(...)
}
\arguments{
\item{server}{A function returning \code{\link[shiny:moduleServer]{shiny::moduleServer()}}}

\item{ui}{A function with a single argument (\code{ns}) returning a \code{shiny.tag}}

\item{class}{Block subclass}

\item{ctor}{String-valued constructor name or function/frame number (mostly
for internal use or when defining constructors for virtual classes)}

\item{...}{Forwarded to \code{new_file_block()} and \code{\link[=new_block]{new_block()}}}

\item{file_path}{File path}

\item{volumes}{Parent namespace}

\item{default}{Default volumes specification (use the blockr option
"volumes" to override)}
}
\value{
All blocks constructed via \code{new_file_block()} inherit from
\code{file_block}.
}
\description{
Similarly to \code{\link[=new_data_block]{new_data_block()}}, blocks created via \code{new_file_block()} serve
as starting points in analysis pipelines by providing data to down-stream
blocks. They typically will not have data inputs and represent root nodes in
analysis graphs.
}
\section{File browser block}{

In order to make user data available to blockr, this block provides file-
upload functionality via \code{\link[shiny:fileInput]{shiny::fileInput()}}. Given that data provided in
this way are only available for the life-time of the shiny session, exported
code is not self-contained and a script containing code from an upload block
is cannot be run in a new session. Also, serialization of upload blocks is
currently not allowed as the full data would have to be included during
serialization.
}

\section{Upload block}{

In order to make user data available to blockr, this block provides file-
upload functionality via \code{\link[shiny:fileInput]{shiny::fileInput()}}. Given that data provided in
this way are only available for the life-time of the shiny session, exported
code is not self-contained and a script containing code from an upload block
is cannot be run in a new session. Also, serialization of upload blocks is
currently not allowed as the full data would have to be included during
serialization.
}

