% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bind.R
\name{new_bind_cols_block}
\alias{new_bind_cols_block}
\title{Bind Columns Block Constructor}
\usage{
new_bind_cols_block(...)
}
\arguments{
\item{...}{Forwarded to \code{\link[blockr.core:new_block]{blockr.core::new_block()}}}
}
\value{
A block object for bind_cols operations
}
\description{
This block allows for column-wise combination of two or more data frames
using \code{\link[dplyr:bind_cols]{dplyr::bind_cols()}}. It combines data frames side-by-side,
requiring them to have the same number of rows. Duplicate column names
are automatically handled by dplyr.
}
\examples{
# Create a bind cols block
new_bind_cols_block()

if (interactive()) {
  library(blockr.core)
  library(blockr.dplyr)

  # Basic usage - combine different datasets horizontally
  serve(
    new_board(
      blocks = list(
        iris_data = new_dataset_block(dataset = "iris"),
        mtcars_data = new_dataset_block(dataset = "mtcars"),
        head1 = new_slice_block(type = "head", n = 5),
        head2 = new_slice_block(type = "head", n = 5),
        combined = new_bind_cols_block()
      ),
      links = links(
        from = c("iris_data", "mtcars_data", "head1", "head2"),
        to = c("head1", "head2", "combined", "combined"),
        input = c("data", "data", "1", "2")
      )
    )
  )

  # Combine selected columns from same dataset
  serve(
    new_board(
      blocks = list(
        mtcars_data = new_dataset_block(dataset = "mtcars"),
        engine_cols = new_select_block(columns = c("mpg", "cyl", "hp")),
        weight_cols = new_select_block(columns = c("wt", "qsec")),
        combined = new_bind_cols_block()
      ),
      links = links(
        from = c("mtcars_data", "mtcars_data", "engine_cols", "weight_cols"),
        to = c("engine_cols", "weight_cols", "combined", "combined"),
        input = c("data", "data", "1", "2")
      )
    )
  )
}

}
