% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter.R
\name{new_filter_block}
\alias{new_filter_block}
\alias{new_value_filter_block}
\title{Filter block constructor}
\usage{
new_filter_block(conditions = list(), preserve_order = FALSE, ...)
}
\arguments{
\item{conditions}{List of filter conditions. Each condition should be a list
with elements: column (character), values (vector), mode ("include" or "exclude"),
and optionally operator ("&" or "|") specifying how this condition connects to
the previous one}

\item{preserve_order}{Logical. If TRUE, preserves the order of selected values
in the filtered output (default: FALSE)}

\item{...}{Additional arguments forwarded to \code{\link[blockr.core:new_block]{blockr.core::new_block()}}}
}
\value{
A block object for value-based filter operations
}
\description{
This block allows filtering rows in a data frame by selecting specific values
from columns (see \code{\link[dplyr:filter]{dplyr::filter()}}). Provides a visual interface where users
can select columns and choose which values to include or exclude without
writing R expressions. Supports multiple conditions with AND/OR logic.
}
\details{
For expression-based filtering, see \code{\link[=new_filter_expr_block]{new_filter_expr_block()}}.
}
\examples{
# Create a filter block
new_filter_block()

if (interactive()) {
  # Basic usage with mtcars dataset
  library(blockr.core)
  serve(new_filter_block(), list(data = mtcars))

  # With initial condition
  serve(new_filter_block(
    conditions = list(
      list(column = "cyl", values = c(4, 6), mode = "include")
    )
  ), list(data = mtcars))

  # Connected blocks example
  serve(
    new_board(
      blocks = list(
        a = new_dataset_block(),
        b = new_filter_block()
      ),
      links = links(
        from = c("a"),
        to = c("b")
      )
    )
  )
}
}
\seealso{
\code{\link[blockr.core:new_transform_block]{blockr.core::new_transform_block()}}
}
