% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_expr.R
\name{new_filter_expr_block}
\alias{new_filter_expr_block}
\title{Expression filter block constructor}
\usage{
new_filter_expr_block(exprs = "TRUE", ...)
}
\arguments{
\item{exprs}{Reactive expression returning character vector of
filter conditions (default: "TRUE" for no filtering)}

\item{...}{Additional arguments forwarded to \code{\link[blockr.core:new_block]{blockr.core::new_block()}}}
}
\value{
A block object for expression-based filter operations
}
\description{
This block allows filtering rows in a data frame based on R expressions
(see \code{\link[dplyr:filter]{dplyr::filter()}}). Supports multiple conditions with AND/OR logic.
Changes are applied after clicking the submit button.
}
\examples{
# Create a filter block
new_filter_expr_block("mpg > 20")

if (interactive()) {
  # Basic usage with mtcars dataset
  library(blockr.core)
  serve(new_filter_expr_block(), list(data = mtcars))

  # With custom initial condition
  serve(new_filter_expr_block("mpg > 20"), list(data = mtcars))

  # Connected blocks example
  serve(
    new_board(
      blocks = list(
        a = new_dataset_block(),
        b = new_filter_expr_block()
      ),
      links = links(
        from = c("a"),
        to = c("b")
      )
    )
  )
}
}
\seealso{
\code{\link[blockr.core:new_transform_block]{blockr.core::new_transform_block()}}
}
