% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rename.R
\name{new_rename_block}
\alias{new_rename_block}
\title{Rename block constructor}
\usage{
new_rename_block(renames = list(new_col = character()), ...)
}
\arguments{
\item{renames}{Named list or vector of renames in new_name = old_name format}

\item{...}{Additional arguments forwarded to \code{\link[blockr.core:new_block]{blockr.core::new_block()}}}
}
\value{
A block object for rename operations
}
\description{
This block allows renaming columns in a data frame using the visual interface
(see \code{\link[dplyr:rename]{dplyr::rename()}}). Changes are applied after clicking the submit button.
Uses new_name = old_name syntax where new_name is what you want to call the column
and old_name is the current column name.
}
\examples{
# Create a rename block
new_rename_block(list(miles_per_gallon = "mpg", cylinders = "cyl"))

if (interactive()) {
  # Basic usage with mtcars dataset
  library(blockr.core)
  serve(new_rename_block(), data = list(data = mtcars))

  # With predefined renames
  serve(
    new_rename_block(list(miles_per_gallon = "mpg", cylinders = "cyl")),
    data = list(data = mtcars)
  )

  # Connected blocks example
  serve(
    new_board(
      blocks = list(
        a = new_dataset_block(),
        b = new_rename_block(list(horsepower = "hp"))
      ),
      links = links(
        from = c("a"),
        to = c("b")
      )
    )
  )
}
}
\seealso{
\code{\link[blockr.core:new_transform_block]{blockr.core::new_transform_block()}}
}
