% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize.R
\name{new_summarize_block}
\alias{new_summarize_block}
\alias{new_summarize_nocode_block}
\title{Summarize block constructor}
\usage{
new_summarize_block(
  summaries = list(count = list(func = "dplyr::n", col = "")),
  by = character(),
  ...
)
}
\arguments{
\item{summaries}{Named list where each element is a list with 'func' and 'col' elements.
For example: list(avg_mpg = list(func = "mean", col = "mpg"))}

\item{by}{Columns to define grouping}

\item{...}{Additional arguments forwarded to \code{\link[blockr.core:new_block]{blockr.core::new_block()}}}
}
\value{
A block object for no-code summarize operations
}
\description{
This block provides a no-code interface for summarizing data (see \code{\link[dplyr:summarise]{dplyr::summarize()}}).
Instead of writing expressions, users select summary functions from dropdowns
(mean, median, sum, etc.), choose columns to summarize, and specify new column names.
}
\details{
For expression-based summarization, see \code{\link[=new_summarize_expr_block]{new_summarize_expr_block()}}.
}
\section{Extending available functions}{

The list of available summary functions can be extended using the
\code{blockr.dplyr.summary_functions} option. Set this option to a named
character vector where names are display labels and values are function calls:

\preformatted{
options(
  blockr.dplyr.summary_functions = c(
    "extract parentheses (paren_num)" = "blockr.topline::paren_num"
  )
)
}

If a description is not provided (empty name), the function name will be
used as the display label.
}

\examples{
# Create a summarize block
new_summarize_block()

if (interactive()) {
  # Basic usage with mtcars dataset
  library(blockr.core)
  serve(new_summarize_block(), data = list(data = mtcars))

  # With predefined summaries
  serve(
    new_summarize_block(
      summaries = list(
        avg_mpg = list(func = "mean", col = "mpg"),
        max_hp = list(func = "max", col = "hp")
      )
    ),
    data = list(data = mtcars)
  )

  # With grouping
  serve(
    new_summarize_block(
      summaries = list(avg_mpg = list(func = "mean", col = "mpg")),
      by = "cyl"
    ),
    data = list(data = mtcars)
  )
}
}
\seealso{
\code{\link[blockr.core:new_transform_block]{blockr.core::new_transform_block()}}, \code{\link[=new_summarize_expr_block]{new_summarize_expr_block()}}
}
