% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boiwsa.R
\name{boiwsa}
\alias{boiwsa}
\title{Seasonal adjustment of weekly data}
\usage{
boiwsa(
  x,
  dates,
  r = 0.8,
  auto.ao.search = TRUE,
  out.threshold = 3.8,
  ao.list = NULL,
  my.k_l = NULL,
  H = NULL,
  ic = "aicc",
  method = "additive"
)
}
\arguments{
\item{x}{Numeric vector containing the observed weekly time series.}

\item{dates}{A vector of class \code{"Date"} corresponding to the observation dates.}

\item{r}{Numeric scalar in (0, 1] defining the rate of decay of the observation weights. Defaults to \code{0.8}.}

\item{auto.ao.search}{Logical. If \code{TRUE}, additive outliers are detected automatically.}

\item{out.threshold}{Numeric. t-statistic threshold used in the additive outlier search. Defaults to \code{3.8}.}

\item{ao.list}{Optional vector of class \code{"Date"} specifying user-defined additive outlier dates.}

\item{my.k_l}{Optional numeric vector of length two specifying the number of yearly and monthly trigonometric variables. If \code{NULL}, these are selected automatically using the information criteria. The search range is 0:36 and 0:12 with the step size of 6 for the yearly and monthly variables, respectively.}

\item{H}{Optional matrix of holiday and trading-day regressors with the same number of rows as \code{x}.}

\item{ic}{Character string specifying the information criterion used in the automatic selection of trigonometric regressors. One of \code{"aic"}, \code{"aicc"}, or \code{"bic"}. Defaults to \code{"aicc"}.}

\item{method}{Character string specifying the decomposition type. Either \code{"additive"} or \code{"multiplicative"}.}
}
\value{
A list with the following components:
\describe{
\item{sa}{Seasonally adjusted series.}
\item{my.k_l}{Number of trigonometric regressors used to model seasonality.}
\item{sf}{Estimated seasonal component.}
\item{hol.factors}{Estimated holiday and trading-day effects.}
\item{out.factors}{Estimated additive outlier effects.}
\item{beta}{Regression coefficients estimated for the last year of data.}
\item{m}{Unweighted \code{lm} object estimated on the full sample.}
}
}
\description{
Performs seasonal adjustment and forecasting of weekly time series using a
regression-based decomposition framework estimated by discounted least squares.
Seasonality is modeled using trigonometric regressors, while holiday,
trading-day, and calendar effects are incorporated through additional
covariates. Additive outliers can be detected automatically using an optional
outlier search procedure. The function supports both additive and
multiplicative decompositions and produces seasonally adjusted series together
with the associated model components. Worked examples and additional usage
illustrations are available in the package repository on GitHub. See Ginker
(2024), \emph{boiwsa: An R Package for Seasonal Adjustment of Weekly Data},
\emph{The R Journal}, 16(3), 186--197.
}
\details{
The methodological framework implemented in this function is described in
Ginker (2024), \emph{boiwsa: An R Package for Seasonal Adjustment of Weekly Data},
\emph{The R Journal}, 16(3), 186--197.
}
\examples{
 # Not run
 # Seasonal adjustment of weekly US gasoline production
 \donttest{
 data("gasoline.data")
 res=boiwsa(x=gasoline.data$y,dates=gasoline.data$date)}
}
\author{
Tim Ginker
}
