% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/box_unused_attached_pkg_linter.R
\name{box_unused_attached_pkg_linter}
\alias{box_unused_attached_pkg_linter}
\title{\code{box} library unused attached package linter}
\usage{
box_unused_attached_pkg_linter()
}
\value{
A custom linter function for use with \code{r-lib/lintr}.
}
\description{
Checks that all attached packages are used within the source file. This also covers packages
attached using the \code{...}.
}
\details{
For use in \code{rhino}, see the
\href{https://appsilon.github.io/rhino/articles/explanation/rhino-style-guide.html}{Explanation: Rhino style guide}
to learn about the details.
}
\examples{
# will produce lints
code <- "
box::use(
  stringr
)
"

lintr::lint(text = code, linters = box_unused_attached_pkg_linter())

code <- "
box::use(
  alias = stringr
)
"

lintr::lint(text = code, linters = box_unused_attached_pkg_linter())

code <- "
box::use(
  stringr[...]
)
"

lintr::lint(text = code, linters = box_unused_attached_pkg_linter())

# okay
code <- "
box::use(
  stringr
)

stringr$str_pad()
"

lintr::lint(text = code, linters = box_unused_attached_pkg_linter())

code <- "
box::use(
  alias = stringr
)

alias$str_pad()
"

lintr::lint(text = code, linters = box_unused_attached_pkg_linter())

code <- "
box::use(
  stringr[...]
)

str_pad()
"

lintr::lint(text = code, linters = box_unused_attached_pkg_linter())

}
