% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate.BVARGROUPPANEL.R
\name{estimate.BVARGROUPPANEL}
\alias{estimate.BVARGROUPPANEL}
\title{Bayesian estimation of a Bayesian Hierarchical Panel Vector 
Autoregression with fixed or estimated country grouping}
\usage{
\method{estimate}{BVARGROUPPANEL}(specification, S, thin = 1L, show_progress = TRUE)
}
\arguments{
\item{specification}{an object of class \code{BVARGROUPPANEL} generated using the 
\code{specify_bvarPANEL$new()} function.}

\item{S}{a positive integer, the number of posterior draws to be generated}

\item{thin}{a positive integer, specifying the frequency of MCMC output thinning}

\item{show_progress}{a logical value, if \code{TRUE} the estimation progress 
bar is visible}
}
\value{
An object of class \code{PosteriorBVARGROUPPANEL} containing the Bayesian 
estimation output and containing two elements:

\describe{
 \item{\code{posterior}}{a list with a collection of \code{S} draws from the 
 posterior distribution generated via Gibbs sampler. Elements of the list
 correspond to the parameters of the model listed in section \strong{Details}
 and are named respectively:
 \code{A_c}, \code{Sigma_c}, \code{A}, \code{Sigma},
 \code{V}, \code{nu}, \code{m}, \code{w}, \code{s}. 
 }
 \item{\code{last_draw}}{an object of class \code{BVARGROUPPANEL} with the last draw of the 
current MCMC run as the starting value to be passed to the continuation of 
the MCMC estimation using the \code{estimate()} method. }
}
}
\description{
Estimates the Bayesian Hierarchical Panel VAR 
with fixed or estimated country grouping using the Gibbs 
sampler proposed by Sanchez-Martinez & Woźniak (2024).
}
\details{
The Bayesian Hierarchical Panel Vector Autoregressive model with fixed or 
estimated country grouping is estimated using the Gibbs sampler. In this 
estimation procedure all the parameters of the model are estimated jointly.
The list of parameters of the model includes:
\describe{
 \item{\eqn{\mathbf{A}_c}}{a \code{KxN} country-specific autoregressive 
 parameters matrix for each of the countries \eqn{c = 1,\dots,C}}
 \item{\eqn{\mathbf{\Sigma}_c}}{an \code{NxN} country-specific covariance 
 matrix for each of the countries \eqn{c = 1,\dots,C}}
 \item{\eqn{\mathbf{A}}}{a \code{KxN} global autoregressive parameters matrix}
 \item{\eqn{\mathbf{\Sigma}}}{an \code{NxN} global covariance matrix}
 \item{\eqn{\mathbf{V}}}{a \code{KxK} covariance matrix of prior for global autoregressive parameters}
 \item{\eqn{\nu}}{prior degrees of freedom parameter}
 \item{\eqn{m}}{prior average global persistence parameter}
 \item{\eqn{w}}{prior scaling parameter}
 \item{\eqn{s}}{prior scaling parameter}
}
Parameters \eqn{\mathbf{A}_c} and \eqn{\mathbf{\Sigma}_c} are subject to 
country grouping which sets them to the group-specific values.

\strong{Gibbs sampler}
is an algorithm to sample random draws from the posterior distribution of the
parameters of the model given the data. The algorithm is briefly explained 
on an example of a two-parameter model with parameters \eqn{\theta_1} and 
\eqn{\theta_2}. In order to sample from the joint posterior distribution 
\eqn{p(\theta_1,\theta_2|\mathbf{Y})} the Gibbs sampler proceeds by sampling 
from full-conditional posterior distributions of each parameter given data 
and all the other parameters, denoted by \eqn{p(\theta_1|\theta_2,\mathbf{Y})} 
and \eqn{p(\theta_2|\theta_1,\mathbf{Y})}. These distributions are available 
from derivations and should be in a form of distributions that are easy to 
sample random numbers from.

To obtain \code{S} draws from the posterior distribution:
\enumerate{
\item Set the initial values of the parameters \eqn{\theta_2^{(0)}}
\item At each of the \code{s} iterations:
\enumerate{
\item Sample \eqn{\theta_1^{(s)}} from \eqn{p(\theta_1|\theta_2^{(s-1)},\mathbf{Y})}
\item Sample \eqn{\theta_2^{(s)}} from \eqn{p(\theta_2|\theta_1^{(s)},\mathbf{Y})}
} 
\item Repeat step 2. \code{S} times. Return \eqn{\{\theta_1^{(s)},\theta_2^{(s)}\}_{s=1}^{S}} 
as a sample drawn from the posterior distribution \eqn{p(\theta_1,\theta_2|\mathbf{Y})}.
}
The \code{estimate()} function returns the draws from the posterior distribution
of the parameters of the hierarchical panel VAR model listed above.

\strong{Thinning.} 
Thinning is a procedure to reduce the dependence in the returned sample from
the posterior distribution. It is obtained by returning every \code{thin} 
draw in the final sample. This procedure reduces the number of draws returned 
by the \code{estimate()} function.
}
\examples{
# specify the model
specification = specify_bvarGroupPANEL$new(
     data = ilo_dynamic_panel[1:5],
     exogenous = ilo_exogenous_variables[1:5],
     group_allocation = country_grouping_region[1:5]
)
burn_in       = estimate(specification, 10)             # run the burn-in; use say S = 10000
posterior     = estimate(burn_in, 10)                   # estimate the model; use say S = 10000

}
\seealso{
\code{\link{bpvars}}, \code{\link{specify_bvarGroupPANEL}}, 
\code{\link{specify_posterior_bvarGroupPANEL}}, \code{\link{summary.PosteriorBVARGROUPPANEL}},
\code{\link{forecast.PosteriorBVARGROUPPANEL}}
}
\author{
Tomasz Woźniak \email{wozniak.tom@pm.me}
}
