% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_exchange_rate.R
\name{get_exchange_rate}
\alias{get_exchange_rate}
\title{Get US Dollar Exchange Rate (Commercial)}
\usage{
get_exchange_rate(
  start_date = NULL,
  end_date = NULL,
  language = "eng",
  labels = TRUE
)
}
\arguments{
\item{start_date}{Start date for the data period. Accepts multiple formats:
\itemize{
\item \code{"YYYY"} for year only (e.g., \code{"2020"} becomes \code{"2020-01-01"})
\item \code{"YYYY-MM"} for year and month (e.g., \code{"2020-06"} becomes \code{"2020-06-01"})
\item \code{"YYYY-MM-DD"} for a specific date (e.g., \code{"2020-06-15"})
}}

\item{end_date}{End date for the data period. Accepts the same formats as \code{start_date}:
\itemize{
\item \code{"YYYY"} (e.g., \code{"2023"} becomes \code{"2023-12-31"})
\item \code{"YYYY-MM"} (e.g., \code{"2023-12"} becomes the last day of December 2023)
\item \code{"YYYY-MM-DD"} for a specific date
\item \code{NULL} defaults to the current date (today)
}}

\item{language}{Language for column names in the returned data.frame:
\itemize{
\item \code{"eng"} (default): Returns columns \code{date} and \code{exchange_rate}
\item \code{"pt"}: Returns columns \code{data_referencia} and \code{taxa_cambio}
}}

\item{labels}{Logical indicating whether to add variable labels using the \code{labelled}
package. Labels provide descriptive text for each column when available.}
}
\value{
A data.frame with US dollar exchange rate. Columns depend on the \code{language} parameter:
\itemize{
\item English (\code{language = "eng"}): \code{date} (Date), \code{exchange_rate} (numeric, R$/US$)
\item Portuguese (\code{language = "pt"}): \code{data_referencia} (Date), \code{taxa_cambio} (numeric, R$/US$)
}
}
\description{
Downloads daily US dollar exchange rate (commercial, selling) from BCB/SGS.
This function retrieves the daily exchange rate (SGS series 1) in Brazilian Real (R$).
}
\note{
\strong{Series information}: This function uses SGS series 1, which represents the
commercial US dollar selling rate (taxa de câmbio livre - dólar americano - venda).
Data is available from 1984 onward with daily frequency.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
  # Default: last 30 days of exchange rate
  df <- get_exchange_rate()

  # Specific period
  df2 <- get_exchange_rate("2023-01-01", "2023-03-31")

  # Using year-month format for a specific month
  df3 <- get_exchange_rate("2023-06", "2023-06")

  # Portuguese column names and labels
  df4 <- get_exchange_rate(language = "pt")

  # Complete example with all parameters
  df5 <- get_exchange_rate("2023-01-01", "2023-12-31", language = "pt", labels = TRUE)
\dontshow{\}) # examplesIf}
}
