% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbfs.R
\name{db_dbfs_close}
\alias{db_dbfs_close}
\title{DBFS Close}
\usage{
db_dbfs_close(
  handle,
  host = db_host(),
  token = db_token(),
  perform_request = TRUE
)
}
\arguments{
\item{handle}{The handle on an open stream. This field is required.}

\item{host}{Databricks workspace URL, defaults to calling \code{\link[=db_host]{db_host()}}.}

\item{token}{Databricks workspace token, defaults to calling \code{\link[=db_token]{db_token()}}.}

\item{perform_request}{If \code{TRUE} (default) the request is performed, if
\code{FALSE} the httr2 request is returned \emph{without} being performed.}
}
\value{
HTTP Response
}
\description{
Close the stream specified by the input handle.
}
\details{
If the handle does not exist, this call throws an exception with
\code{RESOURCE_DOES_NOT_EXIST.}
}
\section{Typical File Upload Flow}{

\itemize{
\item Call create and get a handle via \code{\link[=db_dbfs_create]{db_dbfs_create()}}
\item Make one or more \code{\link[=db_dbfs_add_block]{db_dbfs_add_block()}} calls with the handle you have
\item Call \code{\link[=db_dbfs_close]{db_dbfs_close()}} with the handle you have
}
}

\seealso{
Other DBFS API: 
\code{\link{db_dbfs_add_block}()},
\code{\link{db_dbfs_create}()},
\code{\link{db_dbfs_delete}()},
\code{\link{db_dbfs_get_status}()},
\code{\link{db_dbfs_list}()},
\code{\link{db_dbfs_mkdirs}()},
\code{\link{db_dbfs_move}()},
\code{\link{db_dbfs_put}()},
\code{\link{db_dbfs_read}()}
}
\concept{DBFS API}
