% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbfs.R
\name{db_dbfs_put}
\alias{db_dbfs_put}
\title{DBFS Put}
\usage{
db_dbfs_put(
  path,
  file = NULL,
  contents = NULL,
  overwrite = FALSE,
  host = db_host(),
  token = db_token(),
  perform_request = TRUE
)
}
\arguments{
\item{path}{The path of the new file. The path should be the absolute DBFS
path (for example \verb{/mnt/my-file.txt}).}

\item{file}{Path to a file on local system, takes precedent over \code{path}.}

\item{contents}{String that is base64 encoded.}

\item{overwrite}{Flag (Default: \code{FALSE}) that specifies whether to overwrite
existing files.}

\item{host}{Databricks workspace URL, defaults to calling \code{\link[=db_host]{db_host()}}.}

\item{token}{Databricks workspace token, defaults to calling \code{\link[=db_token]{db_token()}}.}

\item{perform_request}{If \code{TRUE} (default) the request is performed, if
\code{FALSE} the httr2 request is returned \emph{without} being performed.}
}
\description{
Upload a file through the use of multipart form post.
}
\details{
Either \code{contents} or \code{file} must be specified. \code{file} takes precedent over
\code{contents} if both are specified.

Mainly used for streaming uploads, but can also be used as a convenient
single call for data upload.

The amount of data that can be passed using the contents parameter is limited
to 1 MB if specified as a string (\code{MAX_BLOCK_SIZE_EXCEEDED} is thrown if
exceeded) and 2 GB as a file.
}
\seealso{
Other DBFS API: 
\code{\link{db_dbfs_add_block}()},
\code{\link{db_dbfs_close}()},
\code{\link{db_dbfs_create}()},
\code{\link{db_dbfs_delete}()},
\code{\link{db_dbfs_get_status}()},
\code{\link{db_dbfs_list}()},
\code{\link{db_dbfs_mkdirs}()},
\code{\link{db_dbfs_move}()},
\code{\link{db_dbfs_read}()}
}
\concept{DBFS API}
