% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbfs.R
\name{db_dbfs_read}
\alias{db_dbfs_read}
\title{DBFS Read}
\usage{
db_dbfs_read(
  path,
  offset = 0,
  length = NULL,
  host = db_host(),
  token = db_token(),
  perform_request = TRUE
)
}
\arguments{
\item{path}{The path of the new file. The path should be the absolute DBFS
path (for example \verb{/mnt/my-file.txt}).}

\item{offset}{Offset to read from in bytes.}

\item{length}{Number of bytes to read starting from the offset. This has a
limit of 1 MB, and a default value of 0.5 MB.}

\item{host}{Databricks workspace URL, defaults to calling \code{\link[=db_host]{db_host()}}.}

\item{token}{Databricks workspace token, defaults to calling \code{\link[=db_token]{db_token()}}.}

\item{perform_request}{If \code{TRUE} (default) the request is performed, if
\code{FALSE} the httr2 request is returned \emph{without} being performed.}
}
\description{
Return the contents of a file.
}
\details{
If offset + length exceeds the number of bytes in a file, reads contents
until the end of file.
\itemize{
\item If the file does not exist, this call throws an exception with
\code{RESOURCE_DOES_NOT_EXIST.}
\item If the path is a directory, the read length is negative, or if the offset
is negative, this call throws an exception with \code{INVALID_PARAMETER_VALUE.}
\item If the read length exceeds 1 MB, this call throws an exception with
\code{MAX_READ_SIZE_EXCEEDED.}
}
}
\seealso{
Other DBFS API: 
\code{\link{db_dbfs_add_block}()},
\code{\link{db_dbfs_close}()},
\code{\link{db_dbfs_create}()},
\code{\link{db_dbfs_delete}()},
\code{\link{db_dbfs_get_status}()},
\code{\link{db_dbfs_list}()},
\code{\link{db_dbfs_mkdirs}()},
\code{\link{db_dbfs_move}()},
\code{\link{db_dbfs_put}()}
}
\concept{DBFS API}
