% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/queries.R
\name{db_query_list}
\alias{db_query_list}
\title{List SQL Queries}
\usage{
db_query_list(
  page_size = 20,
  page_token = NULL,
  host = db_host(),
  token = db_token(),
  perform_request = TRUE
)
}
\arguments{
\item{page_size}{Integer, number of results to return for each request.}

\item{page_token}{Token used to get the next page of results. If not
specified, returns the first page of results as well as a next page token if
there are more results.}

\item{host}{Databricks workspace URL, defaults to calling \code{\link[=db_host]{db_host()}}.}

\item{token}{Databricks workspace token, defaults to calling \code{\link[=db_token]{db_token()}}.}

\item{perform_request}{If \code{TRUE} (default) the request is performed, if
\code{FALSE} the httr2 request is returned \emph{without} being performed.}
}
\description{
List SQL Queries
}
\details{
Gets a list of queries accessible to the user, ordered by creation
time. Warning: Calling this API concurrently 10 or more times could result
in throttling, service degradation, or a temporary ban.
}
\seealso{
Other SQL Queries API: 
\code{\link{db_query_create}()},
\code{\link{db_query_delete}()},
\code{\link{db_query_get}()},
\code{\link{db_query_update}()}
}
\concept{SQL Queries API}
