% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adapt_tagesschau.R
\name{tagesschau_news}
\alias{tagesschau_news}
\title{Fetch Tagesschau news items}
\usage{
tagesschau_news(
  regions = NULL,
  ressort = NULL,
  flatten = FALSE,
  flatten_mode = "json"
)
}
\arguments{
\item{regions}{Optional region ids.}

\item{ressort}{Optional ressort filter.}

\item{flatten}{Logical; drop nested list columns.}

\item{flatten_mode}{Flatten strategy for list columns. Use "unnest" to
expand list-columns into multiple rows.}
}
\value{
A tibble with news items.

Includes \code{date_time} as POSIXct in Europe/Berlin.
}
\description{
Fetch Tagesschau news items
}
\details{
Returns current news items with optional filters for region or ressort.
Official docs: https://bundesapi.github.io/tagesschau-api/.
}
\examples{
\dontrun{
tagesschau_news(ressort = "inland", flatten = TRUE)
}

}
\seealso{
\code{\link[=tagesschau_homepage]{tagesschau_homepage()}} and \code{\link[=tagesschau_search]{tagesschau_search()}}.
}
