% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregateStations.R
\name{aggregateStations}
\alias{aggregateStations}
\title{Aggregate Camera Trap Table to Station Level}
\usage{
aggregateStations(
  CTtable,
  stationCol,
  cameraCol = NULL,
  setupCol = NULL,
  retrievalCol = NULL,
  dateFormat = NULL,
  quiet = FALSE
)
}
\arguments{
\item{CTtable}{A data frame or `sf` object representing the camera trap table.
Each row typically represents a unique camera deployment.}

\item{stationCol}{A character string specifying the name of the column in \code{CTtable}
that contains the unique station identifiers.}

\item{cameraCol}{A character string specifying the name of the column in \code{CTtable}
that contains the unique camera (deployment) identifiers.}

\item{setupCol}{character. name of the column containing camera setup dates
in \code{CTtable}}

\item{retrievalCol}{character. name of the column containing camera
retrieval dates in \code{CTtable}}

\item{dateFormat}{character. The format of columns \code{setupCol} and
\code{retrievalCol} (and potential problem columns) in \code{CTtable}. Must
be interpretable by either \code{as.Date} or the "orders" argument
\code{\link[lubridate]{parse_date_time}} in \pkg{lubridate}. Can be a date
or a date-time.}

\item{quiet}{logical. If TRUE, print message if no aggregation is needed.}
}
\value{
A data frame with one row per unique station, containing aggregated information.
         Spatial information (for `sf` objects) is preserved.
}
\description{
Aggregates a camera trap table from a station-camera (location-deployment) level to a station (location) level.
This function is useful when modeling or analysis is conducted at the station level,
when multiple cameras were deployed at a single station or a single camera had multiple deployments.
}
\details{
The aggregation logic handles different column types as follows:
\itemize{
  \item \strong{Station ID (specified by `stationCol`):} Remains unique for each row in the output.
  \item \strong{Camera ID (if present):} A character vector (comma-separated)
        of unique camera IDs deployed at that station.
  \item \strong{Setup/Retrieval Dates:} The earliest setup date and the latest retrieval date
        for all deployments within a station will be retained.
  \item \strong{Numeric Columns:} The `mean` of all values for that station will be calculated.
  \item \strong{Logical Columns:} The `mean` (which effectively calculates the proportion of `TRUE`s)
        of all values for that station will be calculated.
  \item \strong{Character Columns (other than Camera ID):} A character vector of unique values
        (comma-separated) for that station will be created.
  \item \strong{Factor Columns:} Similar to character columns, unique levels will be combined.
  \item \strong{Geometry Column (`sf` objects):} Centroid (midpoint) of all unique points at a 
         station is calculated.
}

It is recommended to inspect the aggregated output carefully, especially for columns
with mixed data types or specific aggregation requirements not covered by the defaults.
}
\note{
The function is mainly intended for aggregating covariates to station level. 
         It does currently not handle camera malfunction (via columns `ProblemX_from` / `ProblemX_to`)
         and does not provide proper handling of problem columns.
         Use \code{\link{cameraOperation}} to aggregate camera trap tables to station level for 
         analyses while accounting for camera malfunction / problem periods.
}
