% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conversion.R
\name{svg_to_png}
\alias{svg_to_png}
\title{Convert SVG to PNG}
\usage{
svg_to_png(
  svg_input,
  output_path = NULL,
  width = NULL,
  height = NULL,
  dpi = 300,
  background = "transparent"
)
}
\arguments{
\item{svg_input}{SVG string or path to an SVG file.}

\item{output_path}{Output path for the PNG file (optional; a temp file is used if NULL).}

\item{width}{Output width in pixels (NULL to infer from SVG and scale by DPI).}

\item{height}{Output height in pixels (NULL to infer from SVG and scale by DPI).}

\item{dpi}{Resolution in dots per inch (default 300 for high quality).}

\item{background}{Background color. Use "transparent" or "none" for transparency
(default), or specify a color like "white", "#FFFFFF", etc.}
}
\value{
Path to the generated PNG file.
}
\description{
Convert an SVG string or SVG file path to a high-quality PNG image.
The function sanitizes the SVG and embeds required WOFF2 fonts (downloaded
on demand into a user cache) to ensure consistent font rendering.

\strong{Important note about DPI}: \code{rsvg} rasterizes primarily based on pixel
dimensions. To make DPI matter, this function scales output pixel size by
\code{(dpi / 96)} when \code{width} / \code{height} are not explicitly provided.
}
\examples{
svg <- svg_card("FAR", list(), list())
file_name <- tempfile(fileext = ".png")
png_path <- svg_to_png(svg, file_name, dpi = 300)
png_path <- svg_to_png(svg, file_name, dpi = 300, background = "white")
}
